/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.http.MediaType;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class WebTestClientTransport
implements GraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final WebTestClient webTestClient;

    WebTestClientTransport(WebTestClient webTestClient) {
        Assert.notNull((Object)webTestClient, (String)"WebTestClient is required");
        this.webTestClient = webTestClient;
    }

    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        Map responseMap = (Map)((WebTestClient.RequestBodySpec)this.webTestClient.post().contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).bodyValue((Object)request.toMap()).exchange().expectStatus().isOk().expectHeader().contentTypeCompatibleWith(MediaType.APPLICATION_JSON).expectBody(MAP_TYPE).returnResult().getResponseBody();
        responseMap = responseMap != null ? responseMap : Collections.emptyMap();
        GraphQlResponse response = GraphQlTransport.createResponse(responseMap);
        return Mono.just((Object)response);
    }

    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        throw new UnsupportedOperationException("Subscriptions not supported over HTTP");
    }
}

