/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.geode.boot.autoconfigure.condition.ConditionalOnMissingProperty;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OnMissingPropertyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String annotationName = ConditionalOnMissingProperty.class.getName();
        AnnotationAttributes annotationAttributesCollection = this.toAnnotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)metadata.getAllAnnotationAttributes(annotationName));
        PropertyResolver propertyResolver = this.getPropertyResolver(context);
        ArrayList<String> allMatchingProperties = new ArrayList<String>();
        annotationAttributesCollection.forEach(annotationAttributes -> {
            List<String> propertyNames = this.collectPropertyNames((AnnotationAttributes)annotationAttributes);
            allMatchingProperties.addAll(this.findMatchingProperties(propertyResolver, propertyNames));
        });
        return this.determineConditionOutcome(allMatchingProperties);
    }

    private <T extends Collection<AnnotationAttributes>> T toAnnotationAttributesFromMultiValueMap(MultiValueMap<String, Object> map) {
        ArrayList annotationAttributesList = new ArrayList();
        map.forEach((key, value) -> {
            int size = value.size();
            for (int index = 0; index < size; ++index) {
                AnnotationAttributes annotationAttributes = this.resolveAnnotationAttributes(annotationAttributesList, index);
                annotationAttributes.put(key, value.get(index));
            }
        });
        return (T)annotationAttributesList;
    }

    private AnnotationAttributes resolveAnnotationAttributes(List<AnnotationAttributes> annotationAttributesList, int index) {
        if (index < annotationAttributesList.size()) {
            return annotationAttributesList.get(index);
        }
        AnnotationAttributes newAnnotationAttributes = new AnnotationAttributes();
        annotationAttributesList.add(newAnnotationAttributes);
        return newAnnotationAttributes;
    }

    private PropertyResolver getPropertyResolver(ConditionContext context) {
        return context.getEnvironment();
    }

    private List<String> collectPropertyNames(AnnotationAttributes annotationAttributes) {
        String prefix = this.getPrefix(annotationAttributes);
        String[] names = this.getNames(annotationAttributes);
        return Arrays.stream(names).map(name -> prefix + name).collect(Collectors.toList());
    }

    private String[] getNames(AnnotationAttributes annotationAttributes) {
        String[] names = annotationAttributes.getStringArray("name");
        String[] values = annotationAttributes.getStringArray("value");
        Assert.isTrue((names.length > 0 || values.length > 0 ? 1 : 0) != 0, (String)String.format("The name or value attribute of @%s is required", ConditionalOnMissingProperty.class.getSimpleName()));
        return names.length > 0 ? names : values;
    }

    private String getPrefix(AnnotationAttributes annotationAttributes) {
        String prefix = annotationAttributes.getString("prefix");
        return StringUtils.hasText((String)prefix) ? (prefix.trim().endsWith(".") ? prefix.trim() : prefix.trim() + ".") : "";
    }

    private Collection<String> findMatchingProperties(PropertyResolver propertyResolver, List<String> propertyNames) {
        return propertyNames.stream().filter(arg_0 -> ((PropertyResolver)propertyResolver).containsProperty(arg_0)).collect(Collectors.toSet());
    }

    private ConditionOutcome determineConditionOutcome(Collection<String> matchingProperties) {
        if (!matchingProperties.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnMissingProperty.class, (Object[])new Object[0]).found("property already defined", "properties already defined").items(matchingProperties));
        }
        return ConditionOutcome.match();
    }
}

