/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.modulith.test.AssertablePublishedEvents;
import org.springframework.modulith.test.PublishedEventsParameterResolver;
import org.springframework.modulith.test.Scenario;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.support.TransactionOperations;

class ScenarioParameterResolver
implements ParameterResolver,
BeforeAllCallback {
    private final PublishedEventsParameterResolver delegate = new PublishedEventsParameterResolver();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return Scenario.class.isAssignableFrom(type);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.delegate.beforeAll(context);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ApplicationContext context = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        TransactionOperations operations = (TransactionOperations)context.getBean(TransactionOperations.class);
        AssertablePublishedEvents events = (AssertablePublishedEvents)this.delegate.resolveParameter(parameterContext, extensionContext);
        return new Scenario(operations, (ApplicationEventPublisher)context, events);
    }
}

