/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.FormatableType;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.modulith.runtime.ApplicationRuntime;
import org.springframework.modulith.runtime.autoconfigure.SpringBootApplicationRuntime;
import org.springframework.util.Assert;

@AutoConfiguration
class SpringModulithRuntimeAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringModulithRuntimeAutoConfiguration.class);

    SpringModulithRuntimeAutoConfiguration() {
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(value={ApplicationRuntime.class})
    SpringBootApplicationRuntime modulithsApplicationRuntime(ApplicationContext context) {
        return new SpringBootApplicationRuntime(context);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    ApplicationModulesRuntime modulesRuntime(ApplicationRuntime runtime) {
        Class<?> mainClass = runtime.getMainApplicationClass();
        Future<ApplicationModules> modules = Executors.newFixedThreadPool(1).submit(() -> ApplicationModulesBootstrap.initializeApplicationModules(mainClass));
        return new ApplicationModulesRuntime(SpringModulithRuntimeAutoConfiguration.toSupplier(modules), runtime);
    }

    @Bean
    ApplicationListener<ApplicationStartedEvent> applicationModuleInitialzingListener(ApplicationModulesRuntime runtime, List<ApplicationModuleInitializer> initializers) {
        return event -> {
            ApplicationModules modules = runtime.get();
            initializers.stream().sorted(modules.getComparator()).map(it -> LOGGER.isDebugEnabled() ? new LoggingApplicationModuleInitializerAdapter((ApplicationModuleInitializer)it, modules) : it).forEach(ApplicationModuleInitializer::initialize);
        };
    }

    private static Supplier<ApplicationModules> toSupplier(Future<ApplicationModules> modules) {
        return () -> {
            try {
                return (ApplicationModules)modules.get();
            }
            catch (Exception o_O) {
                throw new RuntimeException(o_O);
            }
        };
    }

    private static class LoggingApplicationModuleInitializerAdapter
    implements ApplicationModuleInitializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(LoggingApplicationModuleInitializerAdapter.class);
        private final ApplicationModuleInitializer delegate;
        private final ApplicationModules modules;

        public LoggingApplicationModuleInitializerAdapter(ApplicationModuleInitializer delegate, ApplicationModules modules) {
            Assert.notNull((Object)delegate, (String)"ApplicationModuleInitializer must not be null!");
            Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
            this.delegate = delegate;
            this.modules = modules;
        }

        public void initialize() {
            Class listenerType = AopUtils.getTargetClass((Object)this.delegate);
            FormatableType formattable = FormatableType.of((Class)listenerType);
            String formattedListenerType = this.modules.getModuleByType(listenerType).map(arg_0 -> ((FormatableType)formattable).getAbbreviatedFullName(arg_0)).orElseGet(() -> ((FormatableType)formattable).getAbbreviatedFullName());
            LOGGER.debug("Initializing {}.", (Object)formattedListenerType);
            this.delegate.initialize();
            LOGGER.debug("Initializing {} done.", (Object)formattedListenerType);
        }
    }

    private static class ApplicationModulesBootstrap {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesBootstrap.class);

        private ApplicationModulesBootstrap() {
        }

        static ApplicationModules initializeApplicationModules(Class<?> applicationMainClass) {
            LOGGER.debug("Obtaining Spring Modulith application modules\u2026");
            ApplicationModules result = ApplicationModules.of(applicationMainClass);
            long numberOfModules = result.stream().count();
            if (numberOfModules == 0L) {
                LOGGER.warn("No application modules detected!");
            } else {
                LOGGER.debug("Detected {} application modules: {}", (Object)result.stream().count(), result.stream().map(ApplicationModule::getName).toList());
            }
            return result;
        }
    }
}

