/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.modulith.events.EventSerializer;
import org.springframework.modulith.events.config.EventPublicationConfigurationExtension;
import org.springframework.modulith.events.jdbc.DatabaseSchemaInitializer;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcEventPublicationRepository;

@Configuration(proxyBeanMethods=false)
class JdbcEventPublicationAutoConfiguration
implements EventPublicationConfigurationExtension {
    JdbcEventPublicationAutoConfiguration() {
    }

    @Bean
    DatabaseType databaseType(DataSource dataSource) {
        return DatabaseType.from(DatabaseDriver.fromDataSource((DataSource)dataSource));
    }

    @Bean
    JdbcEventPublicationRepository jdbcEventPublicationRepository(JdbcTemplate jdbcTemplate, EventSerializer serializer, DatabaseType databaseType) {
        return new JdbcEventPublicationRepository((JdbcOperations)jdbcTemplate, serializer, databaseType);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.modulith.events.schema-initialization.enabled"}, havingValue="true")
    DatabaseSchemaInitializer databaseSchemaInitializer(JdbcTemplate jdbcTemplate, ResourceLoader resourceLoader, DatabaseType databaseType) {
        return new DatabaseSchemaInitializer((JdbcOperations)jdbcTemplate, resourceLoader, databaseType);
    }
}

