/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.util.StreamUtils;

class DatabaseSchemaInitializer
implements InitializingBean {
    private final JdbcOperations jdbcOperations;
    private final ResourceLoader resourceLoader;
    private final DatabaseType databaseType;

    public DatabaseSchemaInitializer(JdbcOperations jdbcOperations, ResourceLoader resourceLoader, DatabaseType databaseType) {
        this.jdbcOperations = jdbcOperations;
        this.resourceLoader = resourceLoader;
        this.databaseType = databaseType;
    }

    public void afterPropertiesSet() {
        String schemaResourceFilename = this.databaseType.getSchemaResourceFilename();
        Resource schemaDdlResource = this.resourceLoader.getResource(schemaResourceFilename);
        String schemaDdl = DatabaseSchemaInitializer.asString(schemaDdlResource);
        this.jdbcOperations.execute(schemaDdl);
    }

    private static String asString(Resource resource) {
        try {
            return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

