/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.autoconfigure.r2dbc.observation;

import io.micrometer.observation.ObservationRegistry;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.experimental.boot.autoconfigure.r2dbc.observation.R2dbcObservationConnectionFactoryBeanPostProcessor;
import org.springframework.experimental.boot.autoconfigure.r2dbc.observation.R2dbcObservationProperties;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={R2dbcAutoConfiguration.class})
@EnableConfigurationProperties(value={R2dbcProperties.class, R2dbcObservationProperties.class})
@ConditionalOnClass(value={ConnectionFactory.class, ObservationRegistry.class})
@ConditionalOnProperty(prefix="r2dbc.observation", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class R2dbcObservationAutoConfiguration {
    @Bean
    public static R2dbcObservationConnectionFactoryBeanPostProcessor r2dbcObservationConnectionFactoryBeanPostProcessor(R2dbcObservationProperties observationProperties, ObjectProvider<ObservationRegistry> observationRegistry, R2dbcProperties r2dbcProperties) {
        String r2dbcUrl = observationProperties.getUrl();
        if (!StringUtils.hasText((String)r2dbcUrl)) {
            r2dbcUrl = r2dbcProperties.getUrl();
        }
        return new R2dbcObservationConnectionFactoryBeanPostProcessor(observationProperties, observationRegistry, r2dbcUrl);
    }
}

