/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.test.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.experimental.boot.test.context.DynamicProperty;
import org.springframework.experimental.boot.test.context.DynamicPropertyRegistryProperty;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.PropertyPlaceholderHelper;

class DynamicPropertyRegistryPropertyFactory {
    private final ExpressionParser parser = new SpelExpressionParser();

    DynamicPropertyRegistryPropertyFactory() {
    }

    DynamicPropertyRegistryProperty createRegistryProperty(MergedAnnotation<DynamicProperty> mergedAnnotation, Supplier<Object> rootObject) {
        DynamicProperty dynamicProperty;
        DynamicProperty dynamicProperty2 = dynamicProperty = mergedAnnotation.isPresent() ? (DynamicProperty)mergedAnnotation.synthesize() : null;
        if (dynamicProperty == null) {
            return null;
        }
        Properties annotationProperties = new Properties();
        annotationProperties.putAll(this.collectAttributes(mergedAnnotation));
        PropertyPlaceholderHelper propertyResolver = new PropertyPlaceholderHelper("{", "}");
        String value = propertyResolver.replacePlaceholders(dynamicProperty.value(), annotationProperties);
        String name = propertyResolver.replacePlaceholders(dynamicProperty.name(), annotationProperties);
        Expression expression = this.parser.parseExpression(value);
        return new DynamicPropertyRegistryProperty(name, () -> expression.getValue(rootObject.get()));
    }

    private Map<String, Object> collectAttributes(MergedAnnotation<?> mergedAnnotation) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (MergedAnnotation metaSource = mergedAnnotation; metaSource != null; metaSource = metaSource.getMetaSource()) {
            attributes.putAll(metaSource.asMap(new MergedAnnotation.Adapt[0]));
        }
        return attributes;
    }
}

