/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.experimental.boot.server.exec.ClasspathEntry;
import org.springframework.experimental.boot.server.exec.TempDir;
import org.springframework.util.FileSystemUtils;

class ScanningClasspathEntry
implements ClasspathEntry {
    private Log logger = LogFactory.getLog(this.getClass());
    private final String resourcePattern;
    private final Function<String, String> renameResource;
    private Resource[] resources;
    private Path classpath;

    ScanningClasspathEntry(String baseDir) {
        this.resourcePattern = baseDir + "/**";
        this.renameResource = name -> {
            String prefix = baseDir + "/";
            int index = name.lastIndexOf(prefix);
            return index > -1 ? name.substring(index + prefix.length()) : name;
        };
    }

    ScanningClasspathEntry(Class<?> clazz) {
        String resourcePath = ScanningClasspathEntry.toResourceName(clazz.getPackageName());
        this.resourcePattern = resourcePath + "/**";
        this.renameResource = name -> name.substring(name.lastIndexOf(resourcePath));
    }

    Path getClasspath() {
        return this.classpath;
    }

    @Override
    public List<String> resolve() {
        if (this.resources == null) {
            this.resources = this.getResources();
            this.classpath = this.createClasspath(this.resources);
        }
        return this.classpath != null ? Arrays.asList(this.classpath.toFile().getAbsolutePath()) : Collections.emptyList();
    }

    private Path createClasspath(Resource[] resources) {
        if (this.resources == null || this.resources.length == 0) {
            return null;
        }
        try {
            Path classpath = TempDir.tempDir();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + resources.length + " resources for pattern " + this.resourcePattern));
            }
            for (Resource resource : resources) {
                String path = this.renameResource.apply(this.getPath(resource));
                if (path.endsWith("/") || !resource.isReadable()) continue;
                Path destination = classpath.resolve(path);
                destination.getParent().toFile().mkdirs();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Copying " + path + " to " + String.valueOf(destination)));
                }
                Files.copy(resource.getInputStream(), destination, new CopyOption[0]);
            }
            return classpath;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Resource[] getResources() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            return resolver.getResources(this.resourcePattern);
        }
        catch (FileNotFoundException ex) {
            return new Resource[0];
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to resolve " + this.resourcePattern, ex);
        }
    }

    private String getPath(Resource resource) {
        if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            return classPathResource.getPath();
        }
        if (resource instanceof FileSystemResource) {
            FileSystemResource fileSystem = (FileSystemResource)resource;
            return fileSystem.getPath();
        }
        throw new IllegalArgumentException("Resource is not a supported type. " + String.valueOf(resource) + " " + String.valueOf(resource.getClass()));
    }

    @Override
    public void cleanup() {
        try {
            if (this.classpath != null) {
                FileSystemUtils.deleteRecursively((Path)this.classpath);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String toResourceName(String name) {
        String matcher = Pattern.quote(".");
        return name.replaceAll(matcher, "/");
    }
}

