/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import org.springframework.experimental.boot.server.exec.ClasspathEntry;
import org.springframework.experimental.boot.server.exec.TempDir;
import org.springframework.util.FileSystemUtils;

public class ResourceClasspathEntry
implements ClasspathEntry {
    private final String existingResourceName;
    private final String classpathResourceName;
    private Path classpath;

    public ResourceClasspathEntry(Class<?> clazz) {
        this.existingResourceName = clazz.getName().replace('.', '/') + ".class";
        this.classpathResourceName = this.existingResourceName;
    }

    public ResourceClasspathEntry(String existingResourceName, String classpathResourceName) {
        this.existingResourceName = existingResourceName;
        this.classpathResourceName = classpathResourceName;
    }

    boolean exists() {
        return this.getExistingResourceAsStream() != null;
    }

    @Override
    public List<String> resolve() {
        if (this.classpath == null) {
            this.classpath = TempDir.tempDir();
            InputStream resource = this.getExistingResourceAsStream();
            try {
                Path destination = this.classpath.resolve(this.classpathResourceName);
                destination.toFile().getParentFile().mkdirs();
                Files.copy(resource, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to copy existingResourceName '" + this.existingResourceName + "' to '" + this.classpathResourceName + "'", ex);
            }
        }
        return Arrays.asList(this.classpath.toFile().getAbsolutePath());
    }

    private InputStream getExistingResourceAsStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this.existingResourceName);
    }

    @Override
    public void cleanup() {
        try {
            FileSystemUtils.deleteRecursively((Path)this.classpath);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

