/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;

final class ProcessDestroyerBean
implements ProcessDestroyer {
    private static final Log logger = LogFactory.getLog(ProcessDestroyerBean.class);
    private final List<Process> processes = new ArrayList<Process>();

    ProcessDestroyerBean() {
    }

    public boolean add(Process process) {
        return this.processes.add(process);
    }

    public boolean remove(Process process) {
        return this.processes.remove(process);
    }

    public int size() {
        return this.processes.size();
    }

    void destroyAll() {
        for (Process process : this.processes) {
            try {
                process.destroy();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)LogMessage.format((String)"Error destroying process %s", (Object)process), throwable);
            }
        }
    }
}

