/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.io.IOException;
import java.nio.file.WatchService;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.server.WebServer;
import org.springframework.experimental.boot.server.exec.ApplicationPortFileWatcher;
import org.springframework.experimental.boot.server.exec.ProcessDestroyerBean;
import org.springframework.util.FileSystemUtils;

public final class CommonsExecWebServer
implements WebServer,
InitializingBean,
DisposableBean,
AutoCloseable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final CommandLine commandLine;
    private final File applicationPortFile;
    private final Runnable cleanup;
    private final WatchServiceExecuteResultHandler handler = new WatchServiceExecuteResultHandler();
    private ProcessDestroyerBean processDestroyerBean = new ProcessDestroyerBean();
    private boolean start;

    CommonsExecWebServer(CommandLine commandLine, File applicationPortFile, Runnable cleanup) {
        this.commandLine = commandLine;
        this.applicationPortFile = applicationPortFile;
        this.cleanup = cleanup;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() {
        this.stop();
    }

    public void start() {
        if (this.start) {
            return;
        }
        this.start = true;
        DefaultExecutor executor = new DefaultExecutor();
        executor.setProcessDestroyer((ProcessDestroyer)this.processDestroyerBean);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing command: " + String.valueOf(this.commandLine)));
            }
            executor.execute(this.commandLine, null, (ExecuteResultHandler)this.handler);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to run the command", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForServer() {
        Object object = this.handler.lock;
        synchronized (object) {
            try {
                this.handler.lock.wait();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void stop() {
        this.processDestroyerBean.destroyAll();
        this.cleanup.run();
        FileSystemUtils.deleteRecursively((File)this.applicationPortFile);
    }

    public int getPort() {
        ApplicationPortFileWatcher applicationPortFileWatcher = new ApplicationPortFileWatcher(this.applicationPortFile, this.handler::watchService);
        try {
            return applicationPortFileWatcher.getApplicationPort();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Failed to get port " + String.valueOf(this.handler.failure), ex);
        }
    }

    CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private static class WatchServiceExecuteResultHandler
    implements ExecuteResultHandler {
        private WatchService watchService;
        private ExecuteException failure;
        private Object lock = new Object();

        private WatchServiceExecuteResultHandler() {
        }

        synchronized void watchService(WatchService watchService) {
            if (this.failure != null) {
                throw new IllegalStateException("The server failed to start ", (Throwable)this.failure);
            }
            this.watchService = watchService;
        }

        public synchronized void onProcessComplete(int exitValue) {
            this.completed();
            this.closeWatchService();
        }

        public synchronized void onProcessFailed(ExecuteException ex) {
            this.completed();
            this.failure = ex;
            this.closeWatchService();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completed() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        private void closeWatchService() {
            if (this.watchService != null) {
                try {
                    this.watchService.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to close WatchService", ex);
                }
            }
        }
    }
}

