/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class IntegrationContextUtils {
    public static final String TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    public static final String YARN_INTEGRATION_CONVERSION_SERVICE_BEAN_NAME = "yarnIntegrationConversionService";

    public static TaskScheduler getTaskScheduler(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, TASK_SCHEDULER_BEAN_NAME, TaskScheduler.class);
    }

    public static TaskScheduler getRequiredTaskScheduler(BeanFactory beanFactory) {
        TaskScheduler taskScheduler = IntegrationContextUtils.getTaskScheduler(beanFactory);
        Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"No such bean 'taskScheduler'");
        return taskScheduler;
    }

    public static ConversionService getConversionService(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, YARN_INTEGRATION_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    private static <T> T getBeanOfType(BeanFactory beanFactory, String beanName, Class<T> type) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            return null;
        }
        return (T)beanFactory.getBean(beanName, type);
    }
}

