/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.yarn.am.AppmasterService;
import org.springframework.yarn.integration.IntegrationAppmasterService;
import org.springframework.yarn.integration.support.PortExposingTcpSocketSupport;

public class IntegrationAppmasterServiceFactoryBean
implements FactoryBean<AppmasterService>,
InitializingBean,
DisposableBean,
BeanFactoryAware {
    private AppmasterService appmasterService;
    private SubscribableChannel messageChannel;
    private PortExposingTcpSocketSupport socketSupport;
    private Class<AppmasterService> serviceImpl;
    private IntegrationAppmasterService<?> serviceRef;
    private BeanFactory beanFactory;

    public AppmasterService getObject() throws Exception {
        return this.appmasterService;
    }

    public Class<AppmasterService> getObjectType() {
        return AppmasterService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.serviceRef != null || this.serviceImpl != null ? 1 : 0) != 0, (String)"Both serviceRef and serviceImpl must not be null");
        Assert.isTrue((this.serviceRef == null || this.serviceImpl == null ? 1 : 0) != 0, (String)"Either serviceRef or serviceImpl can be defined");
        if (this.serviceRef != null) {
            this.appmasterService = this.serviceRef;
        } else if (this.serviceImpl != null && ClassUtils.isAssignable(AppmasterService.class, this.serviceImpl)) {
            this.appmasterService = (AppmasterService)BeanUtils.instantiateClass(this.serviceImpl);
        } else {
            throw new IllegalArgumentException("serviceImpl [" + this.serviceImpl + "] not assignable for AppmasterService");
        }
        if (this.appmasterService instanceof IntegrationAppmasterService) {
            ((IntegrationAppmasterService)this.appmasterService).setMessageChannel(this.messageChannel);
            ((IntegrationAppmasterService)this.appmasterService).setSocketSupport(this.socketSupport);
        }
        if (this.appmasterService instanceof SmartLifecycle) {
            ((SmartLifecycle)this.appmasterService).start();
        }
        if (this.beanFactory != null && this.appmasterService instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.appmasterService).setBeanFactory(this.beanFactory);
        }
    }

    public void destroy() throws Exception {
        if (this.appmasterService instanceof SmartLifecycle) {
            ((SmartLifecycle)this.appmasterService).stop();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setChannel(SubscribableChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void setSocketSupport(PortExposingTcpSocketSupport socketSupport) {
        this.socketSupport = socketSupport;
    }

    public void setServiceImpl(Class<AppmasterService> serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    public void setServiceRef(IntegrationAppmasterService<?> serviceRef) {
        this.serviceRef = serviceRef;
    }
}

