/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.partition;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.util.StringUtils;
import org.springframework.yarn.am.container.ContainerRequestHint;
import org.springframework.yarn.batch.am.AbstractBatchAppmaster;
import org.springframework.yarn.batch.partition.AbstractPartitionHandler;

public class SplitterPartitionHandler
extends AbstractPartitionHandler {
    public SplitterPartitionHandler() {
    }

    public SplitterPartitionHandler(AbstractBatchAppmaster batchAppmaster) {
        super(batchAppmaster);
    }

    @Override
    protected Set<StepExecution> createSplits(StepExecutionSplitter stepSplitter, StepExecution stepExecution) throws Exception {
        return stepSplitter.split(stepExecution, 0);
    }

    @Override
    protected Map<StepExecution, ContainerRequestHint> createRequestData(Set<StepExecution> stepExecutions) throws Exception {
        HashMap<StepExecution, ContainerRequestHint> requests = new HashMap<StepExecution, ContainerRequestHint>();
        for (StepExecution execution : stepExecutions) {
            String locations = execution.getExecutionContext().getString(this.getKeySplitLocations());
            String[] hosts = StringUtils.delimitedListToStringArray((String)locations, (String)",");
            String[] racks = new String[]{};
            requests.put(execution, new ContainerRequestHint((Object)execution, null, hosts, racks, null));
        }
        return requests;
    }
}

