/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.partition;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.yarn.batch.am.BatchYarnAppmaster;
import org.springframework.yarn.batch.partition.AbstractPartitionHandler;

public class StaticPartitionHandler
extends AbstractPartitionHandler {
    private static final Log log = LogFactory.getLog(StaticPartitionHandler.class);
    private int gridSize = 1;

    public StaticPartitionHandler() {
    }

    public StaticPartitionHandler(BatchYarnAppmaster batchAppmaster) {
        super(batchAppmaster);
    }

    public StaticPartitionHandler(BatchYarnAppmaster batchAppmaster, int gridSize) {
        super(batchAppmaster);
        this.gridSize = gridSize;
    }

    @Override
    protected Set<StepExecution> createSplits(StepExecutionSplitter stepSplitter, StepExecution stepExecution) throws Exception {
        log.info((Object)("Creating splits for stepExecution=[" + stepExecution + "] with gridSize=" + this.gridSize));
        return stepSplitter.split(stepExecution, this.gridSize);
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }
}

