/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.yarn.batch.repository.bindings.ExecutionContextType;
import org.springframework.yarn.batch.repository.bindings.JobExecutionType;
import org.springframework.yarn.batch.repository.bindings.JobInstanceType;
import org.springframework.yarn.batch.repository.bindings.JobParameterType;
import org.springframework.yarn.batch.repository.bindings.JobParametersType;
import org.springframework.yarn.batch.repository.bindings.StepExecutionType;
import org.springframework.yarn.batch.repository.bindings.exp.FindJobInstancesByJobNameReq;
import org.springframework.yarn.batch.repository.bindings.exp.FindRunningJobExecutionsReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobExecutionsReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceCountReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobInstancesReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetJobNamesReq;
import org.springframework.yarn.batch.repository.bindings.exp.GetStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.AddWithStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionWithJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetStepExecutionCountReq;
import org.springframework.yarn.batch.repository.bindings.repo.IsJobInstanceExistsReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateExecutionContextReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithStepExecutionReq;

public class JobRepositoryRpcFactory {
    public static StepExecutionType convertStepExecutionType(StepExecution stepExecution) {
        return JobRepositoryRpcFactory.convertStepExecutionType(stepExecution, null);
    }

    public static StepExecutionType convertStepExecutionType(StepExecution stepExecution, JobExecution jobExecution) {
        StepExecutionType type = new StepExecutionType();
        type.id = stepExecution.getId();
        type.version = stepExecution.getVersion();
        type.stepName = stepExecution.getStepName();
        type.jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(stepExecution.getJobExecution(), stepExecution);
        type.status = stepExecution.getStatus();
        type.readCount = stepExecution.getReadCount();
        type.writeCount = stepExecution.getWriteCount();
        type.commitCount = stepExecution.getCommitCount();
        type.rollbackCount = stepExecution.getRollbackCount();
        type.readSkipCount = stepExecution.getReadSkipCount();
        type.processSkipCount = stepExecution.getProcessSkipCount();
        type.writeSkipCount = stepExecution.getWriteSkipCount();
        type.startTime = JobRepositoryRpcFactory.nullsafeToMillis(stepExecution.getStartTime());
        type.endTime = JobRepositoryRpcFactory.nullsafeToMillis(stepExecution.getEndTime());
        type.lastUpdated = JobRepositoryRpcFactory.nullsafeToMillis(stepExecution.getLastUpdated());
        type.terminateOnly = stepExecution.isTerminateOnly();
        type.filterCount = stepExecution.getFilterCount();
        type.executionContext = JobRepositoryRpcFactory.convertExecutionContext(stepExecution.getExecutionContext());
        return type;
    }

    public static ExecutionContextType convertExecutionContext(ExecutionContext executionContext) {
        ExecutionContextType type = new ExecutionContextType();
        type.map = new HashMap<String, ExecutionContextType.ObjectEntry>();
        for (Map.Entry entry : executionContext.entrySet()) {
            Object value = entry.getValue();
            type.map.put((String)entry.getKey(), new ExecutionContextType.ObjectEntry(value, value.getClass().getCanonicalName()));
        }
        return type;
    }

    public static ExecutionContext convertExecutionContextType(ExecutionContextType executionContextType) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, ExecutionContextType.ObjectEntry> entry : executionContextType.map.entrySet()) {
            String key = entry.getKey();
            ExecutionContextType.ObjectEntry objectEntry = entry.getValue();
            Object value = null;
            if (String.class.getCanonicalName().equals(objectEntry.clazz)) {
                value = objectEntry.obj;
            } else if (Integer.class.getCanonicalName().equals(objectEntry.clazz)) {
                value = objectEntry.obj;
            } else if (Long.class.getCanonicalName().equals(objectEntry.clazz)) {
                value = objectEntry.obj instanceof Integer ? new Long(((Integer)objectEntry.obj).intValue()) : objectEntry.obj;
            } else if (Double.class.getCanonicalName().equals(objectEntry.clazz)) {
                value = objectEntry.obj;
            }
            if (value == null) continue;
            map.put(key, value);
        }
        return new ExecutionContext(map);
    }

    public static StepExecution convertStepExecutionType(StepExecutionType type) {
        JobExecution jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(type.jobExecution);
        StepExecution stepExecution = type.id != null ? new StepExecution(type.stepName, jobExecution, type.id) : new StepExecution(type.stepName, jobExecution);
        stepExecution.setVersion(type.version);
        stepExecution.setStatus(type.status);
        stepExecution.setReadCount(type.readCount.intValue());
        stepExecution.setWriteCount(type.writeCount.intValue());
        stepExecution.setCommitCount(type.commitCount.intValue());
        stepExecution.setRollbackCount(type.rollbackCount.intValue());
        stepExecution.setReadSkipCount(type.readSkipCount.intValue());
        stepExecution.setProcessSkipCount(type.processSkipCount.intValue());
        stepExecution.setWriteSkipCount(type.writeSkipCount.intValue());
        stepExecution.setStartTime(JobRepositoryRpcFactory.nullsafeToDate(type.startTime));
        stepExecution.setEndTime(JobRepositoryRpcFactory.nullsafeToDate(type.endTime));
        stepExecution.setLastUpdated(JobRepositoryRpcFactory.nullsafeToDate(type.lastUpdated));
        if (type.terminateOnly.booleanValue()) {
            stepExecution.setTerminateOnly();
        }
        stepExecution.setFilterCount(type.filterCount.intValue());
        ExecutionContext executionContext = JobRepositoryRpcFactory.convertExecutionContextType(type.executionContext);
        stepExecution.setExecutionContext(executionContext);
        return stepExecution;
    }

    public static JobExecutionType convertJobExecutionType(JobExecution jobExecution) {
        return JobRepositoryRpcFactory.convertJobExecutionType(jobExecution, null);
    }

    public static JobExecutionType convertJobExecutionType(JobExecution jobExecution, StepExecution stepExecution) {
        JobExecutionType type = new JobExecutionType();
        type.id = jobExecution.getId();
        type.version = jobExecution.getVersion();
        if (jobExecution.getJobInstance() != null) {
            type.jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(jobExecution.getJobInstance());
        }
        type.jobConfigurationLocation = jobExecution.getJobConfigurationName();
        type.status = jobExecution.getStatus();
        type.startTime = JobRepositoryRpcFactory.nullsafeToMillis(jobExecution.getStartTime());
        type.endTime = JobRepositoryRpcFactory.nullsafeToMillis(jobExecution.getEndTime());
        type.createTime = JobRepositoryRpcFactory.nullsafeToMillis(jobExecution.getCreateTime());
        type.lastUpdated = JobRepositoryRpcFactory.nullsafeToMillis(jobExecution.getLastUpdated());
        type.exitStatus = jobExecution.getExitStatus().getExitCode();
        type.stepExecutions = new ArrayList<StepExecutionType>();
        for (StepExecution stepExecution2 : jobExecution.getStepExecutions()) {
            if (jobExecution.getStepExecutions().contains(stepExecution2) && stepExecution != null) continue;
            type.stepExecutions.add(JobRepositoryRpcFactory.convertStepExecutionType(stepExecution2, jobExecution));
        }
        type.executionContext = JobRepositoryRpcFactory.convertExecutionContext(jobExecution.getExecutionContext());
        type.jobParameters = JobRepositoryRpcFactory.convertJobParameters(jobExecution.getJobParameters());
        return type;
    }

    public static JobExecution convertJobExecutionType(JobExecutionType type) {
        JobInstance jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(type.jobInstance);
        JobParameters jobParameters = JobRepositoryRpcFactory.convertJobParametersType(type.jobParameters);
        JobExecution jobExecution = new JobExecution(jobInstance, type.id, jobParameters, type.jobConfigurationLocation);
        jobExecution.setVersion(type.version);
        jobExecution.setStatus(type.status);
        jobExecution.setStartTime(JobRepositoryRpcFactory.nullsafeToDate(type.startTime));
        jobExecution.setEndTime(JobRepositoryRpcFactory.nullsafeToDate(type.endTime));
        jobExecution.setCreateTime(JobRepositoryRpcFactory.nullsafeToDate(type.createTime));
        jobExecution.setLastUpdated(JobRepositoryRpcFactory.nullsafeToDate(type.lastUpdated));
        jobExecution.setExitStatus(new ExitStatus(type.exitStatus));
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        for (StepExecutionType stepExecutionType : type.stepExecutions) {
            StepExecution convertStepExecutionType = JobRepositoryRpcFactory.convertStepExecutionType(stepExecutionType);
            stepExecutions.add(convertStepExecutionType);
        }
        jobExecution.addStepExecutions(stepExecutions);
        ExecutionContext executionContext = JobRepositoryRpcFactory.convertExecutionContextType(type.executionContext);
        jobExecution.setExecutionContext(executionContext);
        return jobExecution;
    }

    public static JobInstanceType convertJobInstanceType(JobInstance jobInstance) {
        JobInstanceType type = new JobInstanceType();
        type.id = jobInstance.getId();
        type.version = jobInstance.getVersion();
        type.jobName = jobInstance.getJobName();
        return type;
    }

    public static JobInstance convertJobInstanceType(JobInstanceType type) {
        if (type == null) {
            return null;
        }
        JobInstance jobInstance = new JobInstance(type.id, type.jobName);
        jobInstance.setVersion(type.version);
        return jobInstance;
    }

    public static JobParametersType convertJobParameters(JobParameters jobParameters) {
        JobParametersType type = new JobParametersType();
        type.parameters = new HashMap<String, JobParameterType>();
        Map parameters = jobParameters.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            JobParameterType jobParameterType = new JobParameterType();
            jobParameterType.parameter = ((JobParameter)entry.getValue()).getValue();
            jobParameterType.parameterType = ((JobParameter)entry.getValue()).getType();
            type.parameters.put((String)entry.getKey(), jobParameterType);
        }
        return type;
    }

    public static JobParameters convertJobParametersType(JobParametersType type) {
        HashMap<String, JobParameter> map = new HashMap<String, JobParameter>();
        for (Map.Entry<String, JobParameterType> entry : type.parameters.entrySet()) {
            JobParameter.ParameterType parameterType = entry.getValue().parameterType;
            if (parameterType == JobParameter.ParameterType.DATE) {
                if (entry.getValue().parameter instanceof Integer) {
                    map.put(entry.getKey(), new JobParameter(new Date(((Integer)entry.getValue().parameter).intValue())));
                    continue;
                }
                if (entry.getValue().parameter instanceof Long) {
                    map.put(entry.getKey(), new JobParameter(new Date((Long)entry.getValue().parameter)));
                    continue;
                }
                if (!(entry.getValue().parameter instanceof Date)) continue;
                map.put(entry.getKey(), new JobParameter((Date)entry.getValue().parameter));
                continue;
            }
            if (parameterType == JobParameter.ParameterType.DOUBLE) {
                map.put(entry.getKey(), new JobParameter((Double)entry.getValue().parameter));
                continue;
            }
            if (parameterType == JobParameter.ParameterType.LONG) {
                if (entry.getValue().parameter instanceof Long) {
                    map.put(entry.getKey(), new JobParameter((Long)entry.getValue().parameter));
                    continue;
                }
                if (!(entry.getValue().parameter instanceof Integer)) continue;
                Long tmp = new Long(((Integer)entry.getValue().parameter).intValue());
                map.put(entry.getKey(), new JobParameter(tmp));
                continue;
            }
            if (parameterType != JobParameter.ParameterType.STRING) continue;
            map.put(entry.getKey(), new JobParameter((String)entry.getValue().parameter));
        }
        return new JobParameters(map);
    }

    public static IsJobInstanceExistsReq buildIsJobInstanceExistsReq(String jobName, JobParameters jobParameters) {
        IsJobInstanceExistsReq req = new IsJobInstanceExistsReq();
        HashMap<String, JobParameterType> map = new HashMap<String, JobParameterType>();
        for (Map.Entry parameter : jobParameters.getParameters().entrySet()) {
            JobParameterType type = new JobParameterType();
            type.parameter = ((JobParameter)parameter.getValue()).getValue();
            type.parameterType = ((JobParameter)parameter.getValue()).getType();
            map.put((String)parameter.getKey(), type);
        }
        req.jobName = jobName;
        req.jobParameters = map;
        return req;
    }

    public static CreateJobExecutionReq buildCreateJobExecutionReq(String jobName, JobParameters jobParameters) {
        CreateJobExecutionReq req = new CreateJobExecutionReq();
        HashMap<String, JobParameterType> map = new HashMap<String, JobParameterType>();
        for (Map.Entry parameter : jobParameters.getParameters().entrySet()) {
            JobParameterType type = new JobParameterType();
            type.parameter = ((JobParameter)parameter.getValue()).getValue();
            type.parameterType = ((JobParameter)parameter.getValue()).getType();
            map.put((String)parameter.getKey(), type);
        }
        req.jobName = jobName;
        req.jobParameters = map;
        return req;
    }

    public static CreateJobInstanceReq buildCreateJobInstanceReq(String jobName, JobParameters jobParameters) {
        CreateJobInstanceReq req = new CreateJobInstanceReq();
        HashMap<String, JobParameterType> map = new HashMap<String, JobParameterType>();
        for (Map.Entry parameter : jobParameters.getParameters().entrySet()) {
            JobParameterType type = new JobParameterType();
            type.parameter = ((JobParameter)parameter.getValue()).getValue();
            type.parameterType = ((JobParameter)parameter.getValue()).getType();
            map.put((String)parameter.getKey(), type);
        }
        req.jobName = jobName;
        req.jobParameters = map;
        return req;
    }

    public static CreateJobExecutionWithJobInstanceReq buildCreateJobExecutionWithJobInstanceReq(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        CreateJobExecutionWithJobInstanceReq req = new CreateJobExecutionWithJobInstanceReq();
        HashMap map = new HashMap();
        for (Map.Entry parameter : jobParameters.getParameters().entrySet()) {
            JobParameterType type = new JobParameterType();
            type.parameter = ((JobParameter)parameter.getValue()).getValue();
            type.parameterType = ((JobParameter)parameter.getValue()).getType();
            map.put(parameter.getKey(), type);
        }
        req.jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(jobInstance);
        req.jobConfigurationLocation = jobConfigurationLocation;
        return req;
    }

    public static UpdateWithJobExecutionReq buildSaveJobExecutionReq(JobExecution jobExecution) {
        UpdateWithJobExecutionReq req = new UpdateWithJobExecutionReq();
        req.jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(jobExecution);
        return req;
    }

    public static AddWithStepExecutionReq buildAddWithStepExecutionReq(StepExecution stepExecution) {
        AddWithStepExecutionReq req = new AddWithStepExecutionReq();
        req.stepExecution = JobRepositoryRpcFactory.convertStepExecutionType(stepExecution);
        return req;
    }

    public static GetStepExecutionCountReq buildGetStepExecutionCountReq(JobInstance jobInstance, String stepName) {
        GetStepExecutionCountReq req = new GetStepExecutionCountReq();
        req.jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(jobInstance);
        req.stepName = stepName;
        return req;
    }

    public static GetJobInstanceCountReq buildGetJobInstanceCountReq(String jobName) {
        GetJobInstanceCountReq req = new GetJobInstanceCountReq();
        req.jobName = jobName;
        return req;
    }

    public static GetLastStepExecutionReq buildGetLastStepExecutionReq(JobInstance jobInstance, String stepName) {
        GetLastStepExecutionReq req = new GetLastStepExecutionReq();
        req.jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(jobInstance);
        req.stepName = stepName;
        return req;
    }

    public static UpdateWithStepExecutionReq buildUpdateWithStepExecutionReq(StepExecution stepExecution) {
        UpdateWithStepExecutionReq req = new UpdateWithStepExecutionReq();
        req.stepExecution = JobRepositoryRpcFactory.convertStepExecutionType(stepExecution);
        return req;
    }

    public static GetLastJobExecutionReq buildGetLastJobExecutionReq(String jobName, JobParameters jobParameters) {
        GetLastJobExecutionReq req = new GetLastJobExecutionReq();
        HashMap<String, JobParameterType> map = new HashMap<String, JobParameterType>();
        for (Map.Entry parameter : jobParameters.getParameters().entrySet()) {
            JobParameterType type = new JobParameterType();
            type.parameter = ((JobParameter)parameter.getValue()).getValue();
            type.parameterType = ((JobParameter)parameter.getValue()).getType();
            map.put((String)parameter.getKey(), type);
        }
        req.jobName = jobName;
        req.jobParameters = map;
        return req;
    }

    public static GetJobInstancesReq buildGetJobInstancesReq(String jobName, int start, int count) {
        GetJobInstancesReq req = new GetJobInstancesReq();
        req.jobName = jobName;
        req.count = count;
        req.start = start;
        return req;
    }

    public static FindJobInstancesByJobNameReq buildFindJobInstancesByJobNameReq(String jobName, int start, int count) {
        FindJobInstancesByJobNameReq req = new FindJobInstancesByJobNameReq();
        req.jobName = jobName;
        req.count = count;
        req.start = start;
        return req;
    }

    public static GetJobInstanceReq buildGetJobInstanceReq(Long instanceId) {
        GetJobInstanceReq req = new GetJobInstanceReq();
        req.instanceId = instanceId;
        return req;
    }

    public static GetJobExecutionReq buildGetJobExecutionReq(Long executionId) {
        GetJobExecutionReq req = new GetJobExecutionReq();
        req.executionId = executionId;
        return req;
    }

    public static GetStepExecutionReq buildGetStepExecutionReq(Long jobExecutionId, Long stepExecutionId) {
        GetStepExecutionReq req = new GetStepExecutionReq();
        req.jobExecutionId = jobExecutionId;
        req.stepExecutionId = stepExecutionId;
        return req;
    }

    public static GetJobExecutionsReq buildGetJobExecutionsReq(JobInstance jobInstance) {
        GetJobExecutionsReq req = new GetJobExecutionsReq();
        req.jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(jobInstance);
        return req;
    }

    public static FindRunningJobExecutionsReq buildFindRunningJobExecutionsReq(String jobName) {
        FindRunningJobExecutionsReq req = new FindRunningJobExecutionsReq();
        req.jobName = jobName;
        return req;
    }

    public static GetJobNamesReq buildGetJobNamesReq() {
        return new GetJobNamesReq();
    }

    public static UpdateExecutionContextReq buildUpdateExecutionContextReq(StepExecution stepExecution) {
        UpdateExecutionContextReq req = new UpdateExecutionContextReq();
        req.stepExecution = JobRepositoryRpcFactory.convertStepExecutionType(stepExecution);
        return req;
    }

    public static UpdateExecutionContextReq buildUpdateExecutionContextReq(JobExecution jobExecution) {
        UpdateExecutionContextReq req = new UpdateExecutionContextReq();
        req.jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(jobExecution);
        return req;
    }

    private static Long nullsafeToMillis(Date date) {
        if (date != null) {
            return date.getTime();
        }
        return null;
    }

    private static Date nullsafeToDate(Long millis) {
        if (millis != null) {
            return new Date(millis);
        }
        return null;
    }
}

