/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.container;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.yarn.am.AppmasterServiceClient;
import org.springframework.yarn.batch.container.AbstractBatchYarnContainer;
import org.springframework.yarn.batch.repository.JobRepositoryRpcFactory;
import org.springframework.yarn.batch.repository.bindings.PartitionedStepExecutionStatusReq;
import org.springframework.yarn.integration.IntegrationAppmasterServiceClient;
import org.springframework.yarn.integration.ip.mind.MindAppmasterServiceClient;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;
import org.springframework.yarn.integration.ip.mind.binding.BaseResponseObject;

public class DefaultBatchYarnContainer
extends AbstractBatchYarnContainer {
    private static final Log log = LogFactory.getLog(DefaultBatchYarnContainer.class);

    @Autowired(required=false)
    public void setAppmasterServiceClient(AppmasterServiceClient appmasterServiceClient) {
        super.setIntegrationServiceClient((IntegrationAppmasterServiceClient)appmasterServiceClient);
    }

    protected void runInternal() {
        StepExecution stepExecution;
        Long jobExecutionId = this.safeParse(this.getEnvironment("SHDP_AMSERVICE_BATCH_JOBEXECUTIONID"));
        Long stepExecutionId = this.safeParse(this.getEnvironment("SHDP_AMSERVICE_BATCH_STEPEXECUTIONID"));
        String stepName = this.getEnvironment("SHDP_AMSERVICE_BATCH_STEPNAME");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting StepExecution: " + jobExecutionId + " / " + stepExecutionId));
        }
        if ((stepExecution = this.getJobExplorer().getStepExecution(jobExecutionId, stepExecutionId)) == null) {
            throw new NoSuchStepException("No StepExecution could be located for this request: ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got StepExecution: " + stepExecution));
            log.debug((Object)("Locating Step: " + stepName));
        }
        Step step = this.getStepLocator().getStep(stepName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Located step: " + step));
        }
        if (step == null) {
            throw new NoSuchStepException(String.format("No Step with name [%s] could be located.", stepName));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing step: " + step + " / " + stepExecution));
            }
            step.execute(stepExecution);
        }
        catch (JobInterruptedException e) {
            log.error((Object)"error executing step 1", (Throwable)e);
            stepExecution.setStatus(BatchStatus.STOPPED);
        }
        catch (Throwable e) {
            log.error((Object)"error executing step 2", e);
            stepExecution.addFailureException(e);
            stepExecution.setStatus(BatchStatus.FAILED);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished remote step run, status is " + stepExecution.getStatus()));
        }
        MindAppmasterServiceClient client = (MindAppmasterServiceClient)this.getIntegrationServiceClient();
        PartitionedStepExecutionStatusReq req = new PartitionedStepExecutionStatusReq();
        req.stepExecution = JobRepositoryRpcFactory.convertStepExecutionType(stepExecution);
        BaseResponseObject doMindRequest = client.doMindRequest((BaseObject)req);
        log.info((Object)("got response for status update: " + doMindRequest));
    }

    private Long safeParse(String longString) {
        try {
            return Long.parseLong(longString);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

