/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.Collection;
import java.util.List;
import org.springframework.util.ObjectUtils;

public interface SpellcheckQueryResult {
    public Collection<Alternative> getAlternatives();

    public Collection<Alternative> getAlternatives(String var1);

    public Collection<String> getSuggestions();

    public Collection<String> getSuggestions(String var1);

    public void addSuggestions(String var1, List<Alternative> var2);

    public static class Alternative {
        private final String term;
        private final int termFrequency;
        private final String suggestion;
        private final int suggestionFrequency;

        public Alternative(String term, int termFrequency, String suggestion, int suggestionFrequency) {
            this.term = term;
            this.termFrequency = termFrequency;
            this.suggestion = suggestion;
            this.suggestionFrequency = suggestionFrequency;
        }

        public String getTerm() {
            return this.term;
        }

        public int getTermFrequency() {
            return this.termFrequency;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public int getSuggestionFrequency() {
            return this.suggestionFrequency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Alternative)) {
                return false;
            }
            Alternative that = (Alternative)o;
            if (this.termFrequency != that.termFrequency) {
                return false;
            }
            if (this.suggestionFrequency != that.suggestionFrequency) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.term, (Object)that.term)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.suggestion, (Object)that.suggestion);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.term);
            result = 31 * result + this.termFrequency;
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.suggestion);
            result = 31 * result + this.suggestionFrequency;
            return result;
        }

        public String toString() {
            return "Alternative{term='" + this.term + '\'' + ", termFrequency=" + this.termFrequency + ", suggestion='" + this.suggestion + '\'' + ", suggestionFrequency=" + this.suggestionFrequency + '}';
        }
    }
}

