/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.convert.SolrCustomConversions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class SolrConverterBase
implements SolrConverter,
InitializingBean {
    private final GenericConversionService conversionService = new DefaultConversionService();
    private CustomConversions customConversions = new SolrCustomConversions(Collections.emptyList());

    public Collection<SolrInputDocument> write(@Nullable Iterable<?> source) {
        Assert.notNull(source, (String)"Source must not be null!");
        ArrayList<SolrInputDocument> resultList = new ArrayList<SolrInputDocument>();
        for (Object bean : source) {
            if (bean instanceof SolrInputDocument) {
                resultList.add((SolrInputDocument)bean);
                continue;
            }
            resultList.add(this.createAndWrite(bean));
        }
        return resultList;
    }

    protected SolrInputDocument createAndWrite(Object source) {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        this.write(source, document);
        return document;
    }

    public CustomConversions getCustomConversions() {
        return this.customConversions;
    }

    protected boolean hasCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        return this.customConversions.hasCustomReadTarget(sourceType, targetType);
    }

    protected boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.customConversions.hasCustomWriteTarget(sourceType);
    }

    protected boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> targetType) {
        return this.customConversions.hasCustomWriteTarget(sourceType, targetType);
    }

    protected boolean isSimpleType(Class<?> type) {
        return this.customConversions.isSimpleType(type);
    }

    protected Optional<Class<?>> getCustomWriteTargetType(Class<?> type) {
        return this.customConversions.getCustomWriteTarget(type);
    }

    protected void registerCustomConverters(GenericConversionService conversionService) {
        if (this.customConversions != null) {
            this.customConversions.registerConvertersIn((ConverterRegistry)conversionService);
        }
    }

    public void setCustomConversions(@Nullable CustomConversions customConversions) {
        this.customConversions = customConversions != null ? customConversions : new SolrCustomConversions(Collections.emptyList());
    }

    public GenericConversionService getConversionService() {
        return this.conversionService;
    }

    protected boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    @Nullable
    protected <T> T convert(Object source, Class<T> targetType) {
        return (T)this.conversionService.convert(source, targetType);
    }

    public void afterPropertiesSet() {
        this.registerCustomConverters(this.conversionService);
    }
}

