/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collections;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.util.Assert;

public class QueryFunction
extends AbstractFunction {
    private static final String OPERATION = "query";

    private QueryFunction(Query query) {
        super(Collections.singletonList(query));
    }

    public static QueryFunction query(Query query) {
        Assert.notNull((Object)query, (String)"Cannot create query function for 'null' query.");
        return new QueryFunction(query);
    }

    public static QueryFunction query(String queryString) {
        Assert.hasText((String)queryString, (String)"Cannot create query function for 'empty' queryString.");
        return QueryFunction.query(new SimpleStringCriteria(queryString));
    }

    public static QueryFunction query(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot create query function for 'null' criteria.");
        return QueryFunction.query(new SimpleQuery(criteria));
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

