/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HighlightEntry<T> {
    private final T entity;
    private final List<Highlight> highlights = new ArrayList<Highlight>(1);

    public HighlightEntry(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.entity = entity;
    }

    public T getEntity() {
        return this.entity;
    }

    public List<Highlight> getHighlights() {
        return Collections.unmodifiableList(this.highlights);
    }

    public void addSnipplets(Field field, List<String> snipplets) {
        this.highlights.add(new Highlight(field, snipplets));
    }

    public void addSnipplets(String fieldname, List<String> snipplets) {
        this.addSnipplets(new SimpleField(fieldname), snipplets);
    }

    public static class Highlight {
        private final Field field;
        private final List<String> snipplets;

        Highlight(Field field, @Nullable List<String> snipplets) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = field;
            this.snipplets = snipplets != null ? snipplets : Collections.emptyList();
        }

        Highlight(String fieldname, List<String> snipplets) {
            this(new SimpleField(fieldname), snipplets);
        }

        public Field getField() {
            return this.field;
        }

        public List<String> getSnipplets() {
            return this.snipplets;
        }
    }
}

