/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import org.apache.solr.client.solrj.SolrQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.TermsOptions;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TermsQueryParser
extends QueryParserBase<TermsQuery> {
    public TermsQueryParser(@Nullable MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        super(mappingContext);
    }

    @Override
    public SolrQuery doConstructSolrQuery(TermsQuery query, @Nullable Class<?> domainType) {
        Assert.notNull((Object)query, (String)"Cannot construct solrQuery from null value.");
        SolrQuery solrQuery = new SolrQuery();
        String queryString = this.getQueryString(query, domainType);
        if (StringUtils.hasText((String)queryString)) {
            solrQuery.setParam("q", new String[]{queryString});
        }
        this.appendTermsOptionsToSolrQuery(query.getTermsOptions(), solrQuery);
        this.processTermsFields(solrQuery, query);
        this.appendRequestHandler(solrQuery, query.getRequestHandler());
        return solrQuery;
    }

    protected void appendTermsOptionsToSolrQuery(TermsOptions options, SolrQuery solrQuery) {
        solrQuery.setTerms(true);
        if (options.getLimit() >= 0) {
            solrQuery.setTermsLimit(options.getLimit());
        }
        if (options.getMaxCount() >= -1) {
            solrQuery.setTermsMaxCount(options.getMaxCount());
        }
        if (options.getMinCount() >= 0) {
            solrQuery.setTermsMinCount(options.getMinCount());
        }
        if (StringUtils.hasText((String)options.getPrefix())) {
            solrQuery.setTermsPrefix(options.getPrefix());
        }
        if (StringUtils.hasText((String)options.getRegex())) {
            solrQuery.setTermsRegex(options.getRegex());
        }
        if (options.getRegexFlag() != null) {
            solrQuery.setTermsRegexFlag(options.getRegexFlag().toString().toLowerCase());
        }
        if (options.getSort() != null) {
            solrQuery.setTermsSortString(options.getSort().toString().toLowerCase());
        }
        if (options.getUpperBoundTerm() != null) {
            solrQuery.setTermsUpper(options.getUpperBoundTerm().getTerm());
            solrQuery.setTermsUpperInclusive(options.getUpperBoundTerm().isInclude());
        }
        if (options.getLowerBoundTerm() != null) {
            solrQuery.setTermsUpper(options.getLowerBoundTerm().getTerm());
            solrQuery.setTermsUpperInclusive(options.getLowerBoundTerm().isInclude());
        }
        if (!options.isRaw()) {
            solrQuery.setTermsRaw(options.isRaw());
        }
    }

    private void processTermsFields(SolrQuery solrQuery, TermsQuery query) {
        for (Field field : query.getTermsFields()) {
            this.appendTermsFieldToSolrQuery(field, solrQuery);
        }
    }

    protected void appendTermsFieldToSolrQuery(Field field, SolrQuery solrQuery) {
        if (StringUtils.hasText((String)field.getName())) {
            solrQuery.addTermsField(field.getName());
        }
    }
}

