/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimplePivotField
implements PivotField {
    private static final String DELIMINATOR = ",";
    private final List<Field> fields = new ArrayList<Field>(2);
    @Nullable
    private String name;

    public SimplePivotField(String ... fieldnames) {
        Assert.noNullElements((Object[])fieldnames, (String)"Fieldnames must not contain null values");
        this.splitAndAddFieldnames(fieldnames);
        Assert.state((this.fields.size() > 1 ? 1 : 0) != 0, (String)"2 or more fields required for pivot facets");
    }

    public SimplePivotField(List<Field> fields) {
        Assert.notNull(fields, (String)"Fields should not be null");
        Assert.isTrue((fields.size() > 1 ? 1 : 0) != 0, (String)"A pivot field needs to be composed by 2 or more solr fields");
        this.fields.addAll(fields);
    }

    private void splitAndAddFieldnames(String ... fieldnames) {
        for (String fieldname : fieldnames) {
            if (fieldname.contains(DELIMINATOR)) {
                this.splitAndAddFieldnames(fieldname.split(DELIMINATOR));
                continue;
            }
            this.fields.add(new SimpleField(fieldname));
        }
    }

    @Override
    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.ectractFieldName();
        }
        return this.name;
    }

    private String ectractFieldName() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (i > 0) {
                sb.append(DELIMINATOR);
            }
            sb.append(this.fields.get(i).getName());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePivotField other = (SimplePivotField)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }
}

