/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.support.MappingSolrEntityInformation;
import org.springframework.util.Assert;

public class SolrEntityInformationCreatorImpl
implements SolrEntityInformationCreator {
    private final MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;

    public SolrEntityInformationCreatorImpl(MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
    }

    @Override
    public <T, ID extends Serializable> SolrEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        SolrPersistentEntity persistentEntity = (SolrPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        Assert.notNull((Object)persistentEntity, (String)("not an managed type: " + domainClass));
        return new MappingSolrEntityInformation(persistentEntity);
    }
}

