/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import org.springframework.data.domain.Page;
import org.springframework.data.solr.core.query.result.GroupEntry;
import org.springframework.data.solr.core.query.result.GroupResult;
import org.springframework.util.Assert;

public class SimpleGroupResult<T>
implements GroupResult<T> {
    private int matches;
    private Integer groupsCount;
    private String name;
    private Page<GroupEntry<T>> groupEntries;

    public SimpleGroupResult(int matches, Integer groupsCount, String name, Page<GroupEntry<T>> groupEntries) {
        Assert.isTrue((matches >= 0 ? 1 : 0) != 0, (String)"matches must be >= 0");
        Assert.hasLength((String)name, (String)"group result name must be not empty");
        Assert.notNull(groupEntries, (String)"groupEntries must be not null");
        this.matches = matches;
        this.groupsCount = groupsCount;
        this.name = name;
        this.groupEntries = groupEntries;
    }

    @Override
    public int getMatches() {
        return this.matches;
    }

    @Override
    public Integer getGroupsCount() {
        return this.groupsCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Page<GroupEntry<T>> getGroupEntries() {
        return this.groupEntries;
    }

    public String toString() {
        return "SimpleGroupResult [name=" + this.name + ", matches=" + this.matches + ", groupsCount=" + this.groupsCount + ", groupsEntries.total=" + this.groupEntries.getTotalElements() + "]";
    }
}

