/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.solr.core.query.Query;

public class SpellcheckOptions {
    private Query query;
    private Map<String, Object> params;

    private SpellcheckOptions(Query query, Map<String, Object> params) {
        this.query = query;
        this.params = new LinkedHashMap<String, Object>(params);
    }

    public static SpellcheckOptions spellcheck() {
        return new SpellcheckOptions(null, new LinkedHashMap<String, Object>());
    }

    public static SpellcheckOptions spellcheck(Query q) {
        return new SpellcheckOptions(q, new LinkedHashMap<String, Object>());
    }

    public Query getQuery() {
        return this.query;
    }

    public Map<String, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public SpellcheckOptions buildDictionary() {
        return this.createNewAndAppend("spellcheck.build", true);
    }

    public boolean buildDirectory() {
        return this.params.containsKey("spellcheck.build") ? (Boolean)this.params.get("spellcheck.build") : false;
    }

    public SpellcheckOptions collate() {
        return this.createNewAndAppend("spellcheck.collate", true);
    }

    public boolean getCollate() {
        return this.params.containsKey("spellcheck.collate") ? (Boolean)this.params.get("spellcheck.collate") : false;
    }

    public SpellcheckOptions maxCollations(long max) {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.maxCollations", max);
    }

    public Long getMaxCollations() {
        return (Long)this.params.get("spellcheck.maxCollations");
    }

    public SpellcheckOptions maxCollationTries(long tries) {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.maxCollationTries", tries);
    }

    public Long getMaxCollationTries() {
        return (Long)this.params.get("spellcheck.maxCollationTries");
    }

    public SpellcheckOptions maxCollationEvaluations(long evaluations) {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.maxCollationEvaluations", evaluations);
    }

    public Long getMaxCollationEvaluations() {
        return (Long)this.params.get("spellcheck.maxCollationEvaluations");
    }

    public SpellcheckOptions extendedResults() {
        return this.createNewAndAppend("spellcheck.extendedResults", true);
    }

    public Boolean getExtendedResults() {
        return (Boolean)this.params.get("spellcheck.extendedResults");
    }

    public SpellcheckOptions collateExtendedResults() {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.collateExtendedResults", true);
    }

    public boolean getCollateExtendedResults() {
        return this.params.containsKey("spellcheck.collateExtendedResults") ? (Boolean)this.params.get("spellcheck.collateExtendedResults") : false;
    }

    public SpellcheckOptions maxCollationCollectDocs(long nr) {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.collateMaxCollectDocs", nr);
    }

    public Long getMaxCollationCollectDocs() {
        return (Long)this.params.get("spellcheck.collateMaxCollectDocs");
    }

    public SpellcheckOptions collateParam(String param, Object value) {
        return this.potentiallySetCollate().createNewAndAppend("spellcheck.collateParam." + param, value);
    }

    public Map<String, Object> getCollateParams() {
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            if (!entry.getKey().startsWith("spellcheck.collateParam.")) continue;
            tmp.put(entry.getKey().substring("spellcheck.collateParam.".length()), entry.getValue());
        }
        return tmp;
    }

    public SpellcheckOptions count(long nr) {
        return this.createNewAndAppend("spellcheck.count", nr);
    }

    public Long getCount() {
        return (Long)this.params.get("spellcheck.count");
    }

    public SpellcheckOptions dictionaries(String ... names) {
        return this.createNewAndAppend("spellcheck.dictionary", names);
    }

    public String[] getDictionary() {
        return (String[])this.params.get("spellcheck.dictionary");
    }

    public SpellcheckOptions onlyMorePopular() {
        return this.createNewAndAppend("spellcheck.onlyMorePopular", true);
    }

    public boolean getOnlyMorePopular() {
        return this.params.containsKey("spellcheck.onlyMorePopular") ? (Boolean)this.params.get("spellcheck.onlyMorePopular") : false;
    }

    public SpellcheckOptions maxResultsForSuggest(long nr) {
        return this.createNewAndAppend("spellcheck.maxResultsForSuggest", nr);
    }

    public Long getMaxResultsForSuggest() {
        return (Long)this.params.get("spellcheck.maxResultsForSuggest");
    }

    public SpellcheckOptions alternativeTermCount(long nr) {
        return this.createNewAndAppend("spellcheck.alternativeTermCount", nr);
    }

    public Long getAlternativeTermCount() {
        return (Long)this.params.get("spellcheck.alternativeTermCount");
    }

    public SpellcheckOptions accuracy(float nr) {
        return this.createNewAndAppend("spellcheck.accuracy", Float.valueOf(nr));
    }

    public Float getAccuracy() {
        return (Float)this.params.get("spellcheck.accuracy");
    }

    private SpellcheckOptions potentiallySetCollate() {
        if (this.params.containsKey("spellcheck.collate")) {
            return this;
        }
        return this.collate();
    }

    private SpellcheckOptions createNewAndAppend(String key, Object value) {
        SpellcheckOptions so = new SpellcheckOptions(this.query, this.params);
        so.params.put(key, value);
        return so;
    }
}

