/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CurrencyFunction
extends AbstractFunction {
    private static final String OPERATION = "currency";

    private CurrencyFunction(String fieldname) {
        super(Arrays.asList(fieldname));
    }

    public static CurrencyFunction currency(String fieldname) {
        return CurrencyFunction.currency(fieldname, null);
    }

    public static CurrencyFunction currency(Field field) {
        return CurrencyFunction.currency(field, null);
    }

    public static CurrencyFunction currency(Field field, String currencyCode) {
        Assert.notNull((Object)field, (String)"Field for currency function must not be 'null'.");
        return CurrencyFunction.currency(field.getName(), currencyCode);
    }

    public static CurrencyFunction currency(String fieldname, String currencyCode) {
        Assert.hasText((String)fieldname, (String)"Fieldname for currency function must not be 'empty'.");
        CurrencyFunction function = new CurrencyFunction(fieldname);
        if (StringUtils.hasText((String)currencyCode)) {
            function.addArgument(currencyCode);
        }
        return function;
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

