/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FieldWithQueryParameters;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.ParameterHolder;
import org.springframework.data.solr.core.query.QueryParameterImpl;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class HighlightOptions {
    public static final Field ALL_FIELDS = new Field(){

        @Override
        public String getName() {
            return "*";
        }
    };
    private final ParameterHolder<HighlightParameter> parameterHolder = new ParameterHolder();
    private FilterQuery query;
    private final List<Field> fields = new ArrayList<Field>(1);

    public HighlightOptions addField(Field field) {
        Assert.notNull((Object)field);
        this.fields.add(field);
        return this;
    }

    public HighlightOptions addField(String fieldname) {
        Assert.hasText((String)fieldname);
        return this.addField(new SimpleField(fieldname));
    }

    public HighlightOptions addField(String ... fieldnames) {
        Assert.notNull((Object)fieldnames);
        for (String fieldname : fieldnames) {
            this.addField(fieldname);
        }
        return this;
    }

    public HighlightOptions addFields(Collection<String> fieldnames) {
        Assert.notNull(fieldnames);
        for (String fieldname : fieldnames) {
            this.addField(fieldname);
        }
        return this;
    }

    public FilterQuery getQuery() {
        return this.query;
    }

    public HighlightOptions setQuery(FilterQuery query) {
        this.query = query;
        return this;
    }

    public Integer getFragsize() {
        return (Integer)this.parameterHolder.getParameterValue("hl.fragsize");
    }

    public HighlightOptions setFragsize(Integer fragsize) {
        this.addHighlightParameter("hl.fragsize", fragsize);
        return this;
    }

    public String getFormatter() {
        return (String)this.parameterHolder.getParameterValue("hl.formatter");
    }

    public HighlightOptions setFormatter(String formatter) {
        this.addHighlightParameter("hl.formatter", formatter);
        return this;
    }

    public Integer getNrSnipplets() {
        return (Integer)this.parameterHolder.getParameterValue("hl.snippets");
    }

    public HighlightOptions setNrSnipplets(Integer nrSnipplets) {
        this.addHighlightParameter("hl.snippets", nrSnipplets);
        return this;
    }

    public HighlightOptions setSimplePrefix(String prefix) {
        this.addHighlightParameter("hl.simple.pre", prefix);
        return this;
    }

    public String getSimplePrefix() {
        return (String)this.parameterHolder.getParameterValue("hl.simple.pre");
    }

    public HighlightOptions setSimplePostfix(String postfix) {
        this.addHighlightParameter("hl.simple.post", postfix);
        return this;
    }

    public String getSimplePostfix() {
        return (String)this.parameterHolder.getParameterValue("hl.simple.post");
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Collection<HighlightParameter> getHighlightParameters() {
        return this.parameterHolder.getParameters();
    }

    public HighlightOptions addHighlightParameter(String parameterName, Object value) {
        return this.addHighlightParameter(new HighlightParameter(parameterName, value));
    }

    public HighlightOptions addHighlightParameter(HighlightParameter parameter) {
        Assert.notNull((Object)parameter);
        this.parameterHolder.add(parameter);
        return this;
    }

    public <S> S getHighlightParameterValue(String parameterName) {
        return this.parameterHolder.getParameterValue(parameterName);
    }

    public Collection<FieldWithHighlightParameters> getFieldsWithHighlightParameters() {
        ArrayList<FieldWithHighlightParameters> result = new ArrayList<FieldWithHighlightParameters>();
        for (Field candidate : this.fields) {
            if (!(candidate instanceof FieldWithHighlightParameters)) continue;
            result.add((FieldWithHighlightParameters)candidate);
        }
        return result;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    public static class FieldWithHighlightParameters
    extends FieldWithQueryParameters<HighlightParameter> {
        public FieldWithHighlightParameters(String fieldname) {
            super(fieldname);
        }

        public Integer getNrSnipplets() {
            return (Integer)this.getQueryParameterValue("hl.snippets");
        }

        public FieldWithHighlightParameters setNrSnipplets(Integer nrSnipplets) {
            this.addHighlightParameter("hl.snippets", nrSnipplets);
            return this;
        }

        public Integer getFragsize() {
            return (Integer)this.getQueryParameterValue("hl.fragsize");
        }

        public FieldWithHighlightParameters setFragsize(Integer fragsize) {
            this.addHighlightParameter("hl.fragsize", fragsize);
            return this;
        }

        public Boolean isMergeContigous() {
            return (Boolean)this.getQueryParameterValue("hl.mergeContiguous");
        }

        public FieldWithHighlightParameters setMergeContigous(Boolean mergeContigous) {
            this.addHighlightParameter("hl.mergeContiguous", mergeContigous);
            return this;
        }

        public String getFormatter() {
            return (String)this.getQueryParameterValue("hl.formatter");
        }

        public FieldWithHighlightParameters setFormatter(String formatter) {
            this.addHighlightParameter("hl.formatter", formatter);
            return this;
        }

        public FieldWithHighlightParameters addHighlightParameter(String parameterName, Object value) {
            return this.addHighlightParameter(new HighlightParameter(parameterName, value));
        }

        public FieldWithHighlightParameters addHighlightParameter(HighlightParameter parameter) {
            this.addQueryParameter(parameter);
            return this;
        }
    }

    public static class HighlightParameter
    extends QueryParameterImpl {
        public HighlightParameter(String parameter, Object value) {
            super(parameter, value);
        }
    }
}

