/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.GroupOptions;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryParameter;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.StatsOptions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultQueryParser
extends QueryParserBase<SolrDataQuery> {
    @Override
    public final SolrQuery doConstructSolrQuery(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Cannot construct solrQuery from null value.");
        Assert.notNull((Object)query.getCriteria(), (String)"Query has to have a criteria.");
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setParam("q", new String[]{this.getQueryString(query)});
        if (query instanceof Query) {
            this.processQueryOptions(solrQuery, (Query)query);
        }
        if (query instanceof FacetQuery) {
            this.processFacetOptions(solrQuery, (FacetQuery)query);
        }
        if (query instanceof HighlightQuery) {
            this.processHighlightOptions(solrQuery, (HighlightQuery)query);
        }
        return solrQuery;
    }

    private void processQueryOptions(SolrQuery solrQuery, Query query) {
        this.appendPagination(solrQuery, query.getOffset(), query.getRows());
        this.appendProjectionOnFields(solrQuery, query.getProjectionOnFields());
        this.appendFilterQuery(solrQuery, query.getFilterQueries());
        this.appendSort(solrQuery, query.getSort());
        this.appendDefaultOperator(solrQuery, query.getDefaultOperator());
        this.appendTimeAllowed(solrQuery, query.getTimeAllowed());
        this.appendDefType(solrQuery, query.getDefType());
        this.appendRequestHandler(solrQuery, query.getRequestHandler());
        this.processGroupOptions(solrQuery, query);
        this.processStatsOptions(solrQuery, query);
    }

    private void processFacetOptions(SolrQuery solrQuery, FacetQuery query) {
        if (this.enableFaceting(solrQuery, query)) {
            this.appendFacetingOnFields(solrQuery, query);
            this.appendFacetingQueries(solrQuery, query);
            this.appendFacetingOnPivot(solrQuery, query);
            this.appendRangeFacetingOnFields(solrQuery, query);
        }
    }

    private void setObjectNameOnGroupQuery(Query query, Object object, String name) {
        if (query instanceof QueryParserBase.NamedObjectsQuery) {
            ((QueryParserBase.NamedObjectsQuery)query).setName(object, name);
        }
    }

    private void processStatsOptions(SolrQuery solrQuery, Query query) {
        StatsOptions statsOptions = query.getStatsOptions();
        if (statsOptions == null || CollectionUtils.isEmpty(statsOptions.getFields()) && CollectionUtils.isEmpty(statsOptions.getFacets()) && CollectionUtils.isEmpty(statsOptions.getSelectiveFacets())) {
            return;
        }
        solrQuery.set("stats", true);
        for (Field field : statsOptions.getFields()) {
            solrQuery.add("stats.field", new String[]{field.getName()});
            String selectiveCalcDistinctParam = "f." + field.getName() + "." + "stats.calcdistinct";
            Boolean selectiveCountDistincts = statsOptions.isSelectiveCalcDistincts(field);
            if (selectiveCountDistincts == null) continue;
            solrQuery.add(selectiveCalcDistinctParam, new String[]{String.valueOf(selectiveCountDistincts)});
        }
        for (Field field : statsOptions.getFacets()) {
            solrQuery.add("stats.facet", new String[]{field.getName()});
        }
        for (Map.Entry entry : statsOptions.getSelectiveFacets().entrySet()) {
            Field field = (Field)entry.getKey();
            String prefix = "f." + field.getName() + ".";
            String paramName = prefix + "stats.facet";
            for (Field facetField : (Collection)entry.getValue()) {
                solrQuery.add(paramName, new String[]{facetField.getName()});
            }
        }
    }

    private void processGroupOptions(SolrQuery solrQuery, Query query) {
        GroupOptions groupOptions = query.getGroupOptions();
        if (groupOptions == null || CollectionUtils.isEmpty(groupOptions.getGroupByFields()) && CollectionUtils.isEmpty(groupOptions.getGroupByFunctions()) && CollectionUtils.isEmpty(groupOptions.getGroupByQueries())) {
            return;
        }
        solrQuery.set("group", true);
        solrQuery.set("group.main", groupOptions.isGroupMain());
        solrQuery.set("group.format", new String[]{"grouped"});
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByFields())) {
            for (Field field : groupOptions.getGroupByFields()) {
                solrQuery.add("group.field", new String[]{field.getName()});
            }
        }
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByFunctions())) {
            for (Function function : groupOptions.getGroupByFunctions()) {
                String functionFragment = this.createFunctionFragment(function, 0);
                this.setObjectNameOnGroupQuery(query, function, functionFragment);
                solrQuery.add("group.func", new String[]{functionFragment});
            }
        }
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByQueries())) {
            for (Query groupQuery : groupOptions.getGroupByQueries()) {
                String queryFragment = this.getQueryString(groupQuery);
                this.setObjectNameOnGroupQuery(query, groupQuery, queryFragment);
                solrQuery.add("group.query", new String[]{queryFragment});
            }
        }
        if (groupOptions.getSort() != null) {
            for (Sort.Order order : groupOptions.getSort()) {
                solrQuery.add("group.sort", new String[]{order.getProperty().trim() + " " + (order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc)});
            }
        }
        if (groupOptions.getCachePercent() > 0) {
            solrQuery.add("group.cache.percent", new String[]{String.valueOf(groupOptions.getCachePercent())});
        }
        if (groupOptions.getLimit() != null && groupOptions.getLimit() >= 0) {
            solrQuery.set("group.limit", groupOptions.getLimit().intValue());
        }
        if (groupOptions.getOffset() != null && groupOptions.getOffset() >= 0) {
            solrQuery.set("group.offset", groupOptions.getOffset().intValue());
        }
        solrQuery.set("group.ngroups", groupOptions.isTotalCount());
        solrQuery.set("group.facet", groupOptions.isGroupFacets());
        solrQuery.set("group.truncate", groupOptions.isTruncateFacets());
    }

    protected void processHighlightOptions(SolrQuery solrQuery, HighlightQuery query) {
        if (query.hasHighlightOptions()) {
            HighlightOptions highlightOptions = query.getHighlightOptions();
            solrQuery.setHighlight(true);
            if (!highlightOptions.hasFields()) {
                solrQuery.addHighlightField(HighlightOptions.ALL_FIELDS.getName());
            } else {
                for (Field field : highlightOptions.getFields()) {
                    solrQuery.addHighlightField(field.getName());
                }
                for (HighlightOptions.FieldWithHighlightParameters fieldWithHighlightParameters : highlightOptions.getFieldsWithHighlightParameters()) {
                    this.addPerFieldHighlightParameters(solrQuery, fieldWithHighlightParameters);
                }
            }
            for (HighlightOptions.HighlightParameter option : highlightOptions.getHighlightParameters()) {
                this.addOptionToSolrQuery(solrQuery, option);
            }
            if (highlightOptions.hasQuery()) {
                solrQuery.add("hl.q", new String[]{this.getQueryString(highlightOptions.getQuery())});
            }
        }
    }

    private void addOptionToSolrQuery(SolrQuery solrQuery, QueryParameter option) {
        if (option != null && StringUtils.isNotBlank((CharSequence)option.getName())) {
            solrQuery.add(option.getName(), new String[]{(String)this.conversionService.convert(option.getValue(), String.class)});
        }
    }

    private void addFieldSpecificParameterToSolrQuery(SolrQuery solrQuery, Field field, QueryParameter option) {
        if (option != null && field != null && StringUtils.isNotBlank((CharSequence)option.getName())) {
            if (option.getValue() == null) {
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName()), new String[]{null});
            } else {
                String value = option.getValue().toString();
                if (this.conversionService.canConvert(option.getValue().getClass(), String.class)) {
                    value = (String)this.conversionService.convert(option.getValue(), String.class);
                }
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName()), new String[]{value});
            }
        }
    }

    private void addPerFieldHighlightParameters(SolrQuery solrQuery, HighlightOptions.FieldWithHighlightParameters field) {
        for (HighlightOptions.HighlightParameter option : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, option);
        }
    }

    protected String createPerFieldOverrideParameterName(Field field, String parameterName) {
        return "f." + field.getName() + "." + parameterName;
    }

    private boolean enableFaceting(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions == null || !facetOptions.hasFacets()) {
            return false;
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(facetOptions.getFacetMinCount());
        solrQuery.setFacetLimit(facetOptions.getPageable().getPageSize());
        if (facetOptions.getPageable().getPageNumber() > 0) {
            int offset = Math.max(0, facetOptions.getPageable().getOffset());
            solrQuery.set("facet.offset", offset);
        }
        if (FacetOptions.FacetSort.INDEX.equals((Object)facetOptions.getFacetSort())) {
            solrQuery.setFacetSort("index");
        }
        return true;
    }

    private void appendFacetingOnFields(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        solrQuery.addFacetField(this.convertFieldListToStringArray(facetOptions.getFacetOnFields()));
        if (facetOptions.hasFacetPrefix()) {
            solrQuery.setFacetPrefix(facetOptions.getFacetPrefix());
        }
        for (FacetOptions.FieldWithFacetParameters parametrizedField : facetOptions.getFieldsWithParameters()) {
            this.addPerFieldFacetParameters(solrQuery, parametrizedField);
            if (parametrizedField.getSort() == null || !FacetOptions.FacetSort.INDEX.equals((Object)parametrizedField.getSort())) continue;
            this.addFieldSpecificParameterToSolrQuery(solrQuery, parametrizedField, new FacetOptions.FacetParameter("facet.sort", "index"));
        }
    }

    private void addPerFieldFacetParameters(SolrQuery solrQuery, FacetOptions.FieldWithFacetParameters field) {
        for (FacetOptions.FacetParameter parameter : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, parameter);
        }
    }

    private void appendRangeFacetingOnFields(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetRangeOptions = query.getFacetOptions();
        if (facetRangeOptions == null) {
            return;
        }
        for (FacetOptions.FieldWithRangeParameters<?, ?, ?> rangeField : facetRangeOptions.getFieldsWithRangeParameters()) {
            FacetOptions.FacetParameter param;
            if (rangeField instanceof FacetOptions.FieldWithDateRangeParameters) {
                this.appendFieldFacetingByDateRange(solrQuery, (FacetOptions.FieldWithDateRangeParameters)rangeField);
            } else if (rangeField instanceof FacetOptions.FieldWithNumericRangeParameters) {
                this.appendFieldFacetingByNumberRange(solrQuery, (FacetOptions.FieldWithNumericRangeParameters)rangeField);
            }
            if (rangeField.getHardEnd() != null && rangeField.getHardEnd().booleanValue()) {
                param = new FacetOptions.FacetParameter("facet.range.hardend", true);
                this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param);
            }
            if (rangeField.getOther() != null) {
                param = new FacetOptions.FacetParameter("facet.range.other", rangeField.getOther());
                this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param);
            }
            if (rangeField.getInclude() == null) continue;
            param = new FacetOptions.FacetParameter("facet.range.include", rangeField.getInclude());
            this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param);
        }
    }

    private void appendFieldFacetingByNumberRange(SolrQuery solrQuery, FacetOptions.FieldWithNumericRangeParameters field) {
        solrQuery.addNumericRangeFacet(field.getName(), (Number)field.getStart(), (Number)field.getEnd(), (Number)field.getGap());
    }

    private void appendFieldFacetingByDateRange(SolrQuery solrQuery, FacetOptions.FieldWithDateRangeParameters field) {
        solrQuery.addDateRangeFacet(field.getName(), (Date)field.getStart(), (Date)field.getEnd(), (String)field.getGap());
    }

    private void appendFacetingQueries(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        for (SolrDataQuery fq : facetOptions.getFacetQueries()) {
            String facetQueryString = this.getQueryString(fq);
            if (!StringUtils.isNotBlank((CharSequence)facetQueryString)) continue;
            solrQuery.addFacetQuery(facetQueryString);
        }
    }

    private void appendFacetingOnPivot(SolrQuery solrQuery, FacetQuery query) {
        if (VersionUtil.isSolr3XAvailable()) {
            throw new UnsupportedOperationException("Pivot Facets are not available for solr version lower than 4.x - Please check your depdendencies.");
        }
        FacetOptions facetOptions = query.getFacetOptions();
        String[] pivotFields = this.convertFieldListToStringArray(facetOptions.getFacetOnPivots());
        solrQuery.addFacetPivotField(pivotFields);
    }

    protected void appendFilterQuery(SolrQuery solrQuery, List<FilterQuery> filterQueries) {
        if (CollectionUtils.isEmpty(filterQueries)) {
            return;
        }
        List<String> filterQueryStrings = this.getFilterQueryStrings(filterQueries);
        if (!filterQueryStrings.isEmpty()) {
            solrQuery.setFilterQueries(this.convertStringListToArray(filterQueryStrings));
        }
    }

    protected void appendSort(SolrQuery solrQuery, Sort sort) {
        if (sort == null) {
            return;
        }
        for (Sort.Order order : sort) {
            solrQuery.addSort(order.getProperty(), order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
    }

    private String[] convertFieldListToStringArray(List<? extends Field> fields) {
        String[] strResult = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            strResult[i] = fields.get(i).getName();
        }
        return strResult;
    }

    private String[] convertStringListToArray(List<String> listOfString) {
        String[] strResult = new String[listOfString.size()];
        listOfString.toArray(strResult);
        return strResult;
    }

    private List<String> getFilterQueryStrings(List<FilterQuery> filterQueries) {
        ArrayList<String> filterQueryStrings = new ArrayList<String>(filterQueries.size());
        for (FilterQuery filterQuery : filterQueries) {
            String filterQueryString = this.getQueryString(filterQuery);
            if (!StringUtils.isNotBlank((CharSequence)filterQueryString)) continue;
            filterQueryStrings.add(filterQueryString);
        }
        return filterQueryStrings;
    }
}

