/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.repository.SolrCrudRepository;
import org.springframework.data.solr.repository.SolrRepository;
import org.springframework.data.solr.repository.support.SolrRepositoryFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SolrRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public String getRepositoryFactoryClassName() {
        return SolrRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "solr";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        if (!attributes.getBoolean("multicoreSupport")) {
            builder.addPropertyReference(BeanDefinition.SOLR_OPERATIONS.getBeanName(), attributes.getString("solrTemplateRef"));
        } else {
            builder.addPropertyReference(BeanDefinition.SOLR_SERVER.getBeanName(), attributes.getString("solrServerRef"));
        }
        builder.addPropertyValue("schemaCreationSupport", (Object)attributes.getBoolean("schemaCreationSupport"));
        builder.addPropertyReference(BeanDefinition.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        this.registerSolrMappingContextIfNotPresent(registry, configurationSource);
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SolrExceptionTranslator.class).getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)"solrExceptionTranslator", (Object)configurationSource);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        if (!Boolean.valueOf(element.getAttribute("multicore-support")).booleanValue()) {
            builder.addPropertyReference(BeanDefinition.SOLR_OPERATIONS.getBeanName(), element.getAttribute("solr-template-ref"));
        } else {
            builder.addPropertyReference(BeanDefinition.SOLR_SERVER.getBeanName(), element.getAttribute("solr-server-ref"));
        }
        if (StringUtils.hasText((String)element.getAttribute("schema-creation-support"))) {
            builder.addPropertyValue("schemaCreationSupport", (Object)element.getAttribute("schema-creation-support"));
        }
        builder.addPropertyReference(BeanDefinition.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(SolrDocument.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Arrays.asList(SolrRepository.class, SolrCrudRepository.class);
    }

    private void registerSolrMappingContextIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition definition = new RootBeanDefinition(SimpleSolrMappingContext.class);
        definition.setRole(2);
        definition.setSource(configurationSource.getSource());
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)definition, (BeanDefinitionRegistry)registry, (String)BeanDefinition.SOLR_MAPPTING_CONTEXT.getBeanName(), (Object)definition);
    }

    static enum BeanDefinition {
        SOLR_MAPPTING_CONTEXT("solrMappingContext"),
        SOLR_OPERATIONS("solrOperations"),
        SOLR_SERVER("solrServer");

        String beanName;

        private BeanDefinition(String beanName) {
            this.beanName = beanName;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

