/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.util.Assert;

public class NotFunction
extends AbstractFunction {
    private static final String OPERATION = "not";

    private NotFunction(Object condition) {
        super(Arrays.asList(condition));
    }

    public static NotFunction not(Field field) {
        Assert.notNull((Object)field, (String)"Field for not function must not be 'null'");
        return NotFunction.not(field.getName());
    }

    public static NotFunction not(String fieldname) {
        Assert.hasText((String)fieldname, (String)"Fieldname for not function must not be 'empty'.");
        return new NotFunction(fieldname);
    }

    public static NotFunction not(Function condition) {
        Assert.notNull((Object)condition, (String)"Condition for not function must not be 'null'");
        return new NotFunction(condition);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

