/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.solr.core.convert.CustomConversions;
import org.springframework.data.solr.core.convert.SolrConverter;

public abstract class SolrConverterBase
implements SolrConverter,
InitializingBean {
    private final GenericConversionService conversionService = new DefaultConversionService();
    private CustomConversions customConversions = new CustomConversions();

    public Collection<SolrInputDocument> write(Iterable<?> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<SolrInputDocument> resultList = new ArrayList<SolrInputDocument>();
        for (Object bean : source) {
            if (bean instanceof SolrInputDocument) {
                resultList.add((SolrInputDocument)bean);
                continue;
            }
            resultList.add(this.createAndWrite(bean));
        }
        return resultList;
    }

    protected SolrInputDocument createAndWrite(Object source) {
        SolrInputDocument document = new SolrInputDocument();
        this.write(source, document);
        return document;
    }

    public CustomConversions getCustomConversions() {
        return this.customConversions;
    }

    protected boolean hasCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        return this.customConversions.hasCustomReadTarget(sourceType, targetType);
    }

    protected boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.customConversions.hasCustomWriteTarget(sourceType, null);
    }

    protected boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> targetType) {
        return this.customConversions.hasCustomWriteTarget(sourceType, targetType);
    }

    protected boolean isSimpleType(Class<?> type) {
        return this.customConversions.isSimpleType(type);
    }

    protected Class<?> getCustomWriteTargetType(Class<?> type) {
        return this.customConversions.getCustomWriteTarget(type);
    }

    protected void registerCutomConverters(GenericConversionService conversionService) {
        if (this.customConversions != null) {
            this.customConversions.registerConvertersIn(conversionService);
        }
    }

    public void setCustomConversions(CustomConversions customConversions) {
        this.customConversions = customConversions != null ? customConversions : new CustomConversions();
    }

    public GenericConversionService getConversionService() {
        return this.conversionService;
    }

    protected boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    protected <T> T convert(Object source, Class<T> targetType) {
        return (T)this.conversionService.convert(source, targetType);
    }

    public void afterPropertiesSet() {
        this.registerCutomConverters(this.conversionService);
    }
}

