/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.springframework.util.Assert;

public class SolrRealtimeGetRequest
extends SolrRequest {
    private static final long serialVersionUID = 1500782684874146272L;
    private Collection<String> ids;

    public SolrRealtimeGetRequest(Serializable ... ids) {
        this(Arrays.asList(ids));
    }

    public SolrRealtimeGetRequest(Collection<? extends Serializable> ids) {
        super(SolrRequest.METHOD.GET, "/get");
        Assert.notEmpty(ids, (String)"At least one 'id' is required for real time get request.");
        Assert.noNullElements((Object[])ids.toArray(), (String)"Real time get request can't be made for 'null' id.");
        this.toStringIds(ids);
    }

    private void toStringIds(Collection<? extends Serializable> ids) {
        this.ids = new ArrayList<String>(ids.size());
        for (Serializable serializable : ids) {
            this.ids.add(serializable.toString());
        }
    }

    public SolrParams getParams() {
        return new ModifiableSolrParams().add("ids", this.ids.toArray(new String[this.ids.size()]));
    }

    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    public QueryResponse process(SolrServer server) throws SolrServerException, IOException {
        try {
            long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            QueryResponse res = new QueryResponse(server.request((SolrRequest)this), server);
            long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            res.setElapsedTime(endTime - startTime);
            return res;
        }
        catch (SolrServerException e) {
            throw e;
        }
        catch (SolrException s) {
            throw s;
        }
        catch (Exception e) {
            throw new SolrServerException("Error executing query", (Throwable)e);
        }
    }
}

