/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.SolrjConverters;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.mapping.SolrSimpleTypes;
import org.springframework.util.Assert;

public class CustomConversions {
    private final Set<Class<?>> customSimpleTypes;
    private final List<Object> converters;
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private SimpleTypeHolder simpleTypeHolder;
    private ConcurrentMap<GenericConverter.ConvertiblePair, Class<?>> cache = new ConcurrentHashMap(36, 0.9f, 1);

    public CustomConversions() {
        this(new ArrayList());
    }

    public CustomConversions(List converters) {
        this.converters = converters != null ? new ArrayList<Object>(converters) : new ArrayList();
        this.readingPairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, SolrSimpleTypes.HOLDER);
        this.converters.add((Object)GeoConverters.StringToGeoLocationConverter.INSTANCE);
        this.converters.add((Object)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        this.converters.add((Object)GeoConverters.StringToPointConverter.INSTANCE);
        this.converters.add(new SolrjConverters.UpdateToSolrInputDocumentConverter());
        if (VersionUtil.isJodaTimeAvailable()) {
            this.converters.add((Object)DateTimeConverters.DateToJodaDateTimeConverter.INSTANCE);
            this.converters.add((Object)DateTimeConverters.JodaDateTimeToDateConverter.INSTANCE);
            this.converters.add((Object)DateTimeConverters.DateToLocalDateTimeConverter.INSTANCE);
            this.converters.add((Object)DateTimeConverters.JodaLocalDateTimeToDateConverter.INSTANCE);
        }
        for (Object converter : this.converters) {
            this.registerConversion(converter);
        }
    }

    public void registerConvertersIn(GenericConversionService conversionService) {
        Assert.notNull((Object)conversionService);
        for (Object converter : this.converters) {
            if (converter instanceof Converter) {
                conversionService.addConverter((Converter)converter);
                continue;
            }
            if (converter instanceof ConverterFactory) {
                conversionService.addConverterFactory((ConverterFactory)converter);
                continue;
            }
            if (converter instanceof GenericConverter) {
                conversionService.addConverter((GenericConverter)converter);
                continue;
            }
            throw new IllegalArgumentException("Given object '" + converter + "' expected to be a Converter, ConverterFactory or GenericeConverter!");
        }
    }

    public boolean isSimpleType(Class<?> clazz) {
        return this.simpleTypeHolder.isSimpleType(clazz);
    }

    public Class<?> getCustomWriteTarget(Class<?> source) {
        return this.getCustomWriteTarget(source, null);
    }

    public Class<?> getCustomWriteTarget(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType);
        return this.getCustomTarget(sourceType, targetType, this.writingPairs);
    }

    Class<?> getCustomTarget(Class<?> sourceType, Class<?> expectedTargetType, Iterable<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(sourceType);
        Assert.notNull(pairs);
        GenericConverter.ConvertiblePair expectedTypePair = new GenericConverter.ConvertiblePair(sourceType, expectedTargetType != null ? expectedTargetType : Any.class);
        if (this.cache.containsKey(expectedTypePair)) {
            Class cachedTargetType = (Class)this.cache.get(expectedTypePair);
            return cachedTargetType != Any.class ? cachedTargetType : null;
        }
        for (GenericConverter.ConvertiblePair typePair : pairs) {
            if (!typePair.getSourceType().isAssignableFrom(sourceType)) continue;
            Class targetType = typePair.getTargetType();
            if (expectedTargetType != null && !targetType.isAssignableFrom(expectedTargetType)) continue;
            this.cache.putIfAbsent(expectedTypePair, targetType);
            return targetType;
        }
        this.cache.putIfAbsent(expectedTypePair, Any.class);
        return null;
    }

    public boolean hasCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType);
        Assert.notNull(targetType);
        return this.getCustomReadTarget(sourceType, targetType) != null;
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> targetType) {
        return this.getCustomTarget(sourceType, targetType, this.writingPairs) != null;
    }

    private Class<?> getCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        return this.getCustomTarget(sourceType, targetType, this.readingPairs);
    }

    private void registerConversion(Object converter) {
        Class<?> type = converter.getClass();
        boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
        boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
        if (!isReading && !isWriting) {
            isReading = true;
            isWriting = true;
        }
        if (converter instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)converter;
            for (GenericConverter.ConvertiblePair pair : genericConverter.getConvertibleTypes()) {
                this.register(new ConvertibleContext(pair, isReading, isWriting));
            }
        } else if (converter instanceof Converter) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            this.register(new ConvertibleContext(arguments[0], arguments[1], isReading, isWriting));
        } else {
            throw new IllegalArgumentException("Unsupported Converter type! Expected either GenericConverter if Converter.");
        }
    }

    private void register(ConvertibleContext context) {
        GenericConverter.ConvertiblePair pair = context.getConvertible();
        if (context.isReading()) {
            this.readingPairs.add(pair);
        }
        if (context.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
        }
    }

    private static class Any {
        private Any() {
        }
    }

    static class ConvertibleContext {
        private final GenericConverter.ConvertiblePair convertible;
        private final boolean reading;
        private final boolean writing;

        public ConvertibleContext(GenericConverter.ConvertiblePair convertible, boolean isReading, boolean isWriting) {
            Assert.notNull((Object)convertible);
            this.convertible = convertible;
            this.reading = isReading;
            this.writing = isWriting;
        }

        public ConvertibleContext(Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
            this(new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
        }

        public GenericConverter.ConvertiblePair getConvertible() {
            return this.convertible;
        }

        public boolean isReading() {
            return this.reading;
        }

        public boolean isWriting() {
            return this.writing;
        }
    }
}

