/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.convert.SolrConverterBase;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MappingSolrConverter
extends SolrConverterBase
implements SolrConverter,
ApplicationContextAware,
InitializingBean {
    private final MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private ApplicationContext applicationContext;

    public MappingSolrConverter(MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext);
        this.mappingContext = mappingContext;
    }

    public MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public <S, R> List<R> read(SolrDocumentList source, Class<R> type) {
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<S> resultList = new ArrayList<S>(source.size());
        ClassTypeInformation typeInformation = ClassTypeInformation.from(type);
        for (SolrDocument item : source) {
            resultList.add(this.read((TypeInformation<S>)typeInformation, (Map<String, ?>)item));
        }
        return resultList;
    }

    public <R> R read(Class<R> type, Map<String, ?> source) {
        return (R)this.read((TypeInformation)ClassTypeInformation.from(type), source);
    }

    protected <S> S read(TypeInformation<S> targetTypeInformation, Map<String, ?> source) {
        if (source == null) {
            return null;
        }
        Assert.notNull(targetTypeInformation);
        Class rawType = targetTypeInformation.getType();
        if (this.hasCustomReadTarget(source.getClass(), rawType)) {
            return (S)this.convert(source, rawType);
        }
        SolrPersistentEntity entity = (SolrPersistentEntity)this.mappingContext.getPersistentEntity(rawType);
        return this.read(entity, source, null);
    }

    private <S> S read(final SolrPersistentEntity<S> entity, final Map<String, ?> source, Object parent) {
        ParameterValueProvider<SolrPersistentProperty> parameterValueProvider = this.getParameterValueProvider(entity, source, parent);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, parameterValueProvider);
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.getConversionService());
        final Object result = wrapper.getBean();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<SolrPersistentProperty>(){

            public void doWithPersistentProperty(SolrPersistentProperty persistentProperty) {
                if (entity.isConstructorArgument(persistentProperty)) {
                    return;
                }
                Object o = MappingSolrConverter.this.getValue(persistentProperty, source, result);
                if (o != null) {
                    wrapper.setProperty((PersistentProperty)persistentProperty, o);
                }
            }
        });
        return (S)result;
    }

    protected Object getValue(SolrPersistentProperty property, Object source, Object parent) {
        SolrPropertyValueProvider provider = new SolrPropertyValueProvider(source, parent);
        return provider.getPropertyValue(property);
    }

    private ParameterValueProvider<SolrPersistentProperty> getParameterValueProvider(SolrPersistentEntity<?> entity, Map<String, ?> source, Object parent) {
        SolrPropertyValueProvider provider = new SolrPropertyValueProvider(source, parent);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, parent);
        return parameterProvider;
    }

    public void write(Object source, Map target) {
        if (source == null) {
            return;
        }
        if (this.hasCustomWriteTarget(source.getClass(), SolrInputDocument.class) && this.canConvert(source.getClass(), SolrInputDocument.class)) {
            SolrInputDocument convertedDocument = this.convert(source, SolrInputDocument.class);
            target.putAll(convertedDocument);
            return;
        }
        ClassTypeInformation type = ClassTypeInformation.from(source.getClass());
        this.write((TypeInformation<?>)type, source, target);
    }

    protected void write(TypeInformation<?> type, Object source, Map target) {
        Assert.notNull(type);
        SolrPersistentEntity entity = (SolrPersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        this.write(source, target, entity);
    }

    protected void write(Object source, final Map target, SolrPersistentEntity<?> entity) {
        final BeanWrapper wrapper = BeanWrapper.create((Object)source, (ConversionService)this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<SolrPersistentProperty>(){

            public void doWithPersistentProperty(SolrPersistentProperty persistentProperty) {
                Object value = wrapper.getProperty((PersistentProperty)persistentProperty, persistentProperty.getType());
                if (value == null || persistentProperty.isReadonly()) {
                    return;
                }
                if (persistentProperty.containsWildcard() && !persistentProperty.isMap()) {
                    throw new IllegalArgumentException("Field '" + persistentProperty.getFieldName() + "' must not contain wildcards. Consider excluding Field from beeing indexed.");
                }
                Object fieldValue = value;
                if (persistentProperty.isMap() && persistentProperty.containsWildcard()) {
                    TypeInformation mapTypeInformation = persistentProperty.getTypeInformation().getMapValueType();
                    Class rawMapType = mapTypeInformation.getType();
                    Map map = (Map)fieldValue;
                    for (Map.Entry entry : map.entrySet()) {
                        String mappedFieldName = entry.getKey().toString();
                        SolrInputField field = new SolrInputField(mappedFieldName);
                        if (entry.getValue() instanceof Iterable) {
                            for (Object o : (Iterable)entry.getValue()) {
                                field.addValue(MappingSolrConverter.this.convertToSolrType(rawMapType, o), 1.0f);
                            }
                        } else if (rawMapType.isArray()) {
                            for (Object o : (Object[])entry.getValue()) {
                                field.addValue(MappingSolrConverter.this.convertToSolrType(rawMapType, o), 1.0f);
                            }
                        } else {
                            field.addValue(MappingSolrConverter.this.convertToSolrType(rawMapType, entry.getValue()), 1.0f);
                        }
                        target.put(mappedFieldName, field);
                    }
                    return;
                }
                SolrInputField field = new SolrInputField(persistentProperty.getFieldName());
                if (persistentProperty.isCollectionLike()) {
                    Collection collection = MappingSolrConverter.asCollection(fieldValue);
                    for (Object o : collection) {
                        if (o == null) continue;
                        field.addValue(MappingSolrConverter.this.convertToSolrType(persistentProperty.getType(), o), 1.0f);
                    }
                } else {
                    field.setValue(MappingSolrConverter.this.convertToSolrType(persistentProperty.getType(), fieldValue), 1.0f);
                }
                target.put(persistentProperty.getFieldName(), field);
                if (persistentProperty.isBoosted()) {
                    field.setBoost(persistentProperty.getBoost().floatValue());
                }
            }
        });
        if (entity.isBoosted() && target instanceof SolrInputDocument) {
            ((SolrInputDocument)target).setDocumentBoost(entity.getBoost().floatValue());
        }
    }

    private Object convertToSolrType(Class<?> type, Object value) {
        if (type == null || value == null) {
            return value;
        }
        if (this.isSimpleType(type)) {
            return value;
        }
        if (this.hasCustomWriteTarget(value.getClass())) {
            Class<?> targetType = this.getCustomWriteTargetType(value.getClass());
            if (this.canConvert(value.getClass(), targetType)) {
                return this.convert(value, targetType);
            }
        }
        return value;
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private class SolrPropertyValueProvider
    implements PropertyValueProvider<SolrPersistentProperty> {
        private final Object source;
        private final Object parent;

        public SolrPropertyValueProvider(Object source, Object parent) {
            this.source = source;
            this.parent = parent;
        }

        public <T> T getPropertyValue(SolrPersistentProperty property) {
            if (this.source instanceof Map) {
                return this.readValue((Map)this.source, property, this.parent);
            }
            return this.readValue(this.source, property.getTypeInformation(), this.parent);
        }

        private <T> T readValue(Map<String, ?> value, SolrPersistentProperty property, Object parent) {
            if (value == null) {
                return null;
            }
            if (property.containsWildcard()) {
                return (T)this.readWildcard(value, property, parent);
            }
            return this.readValue(value.get(property.getFieldName()), property.getTypeInformation(), parent);
        }

        private <T> T readValue(Object value, TypeInformation<?> type, Object parent) {
            if (value == null) {
                return null;
            }
            Assert.notNull(type);
            Class rawType = type.getType();
            if (MappingSolrConverter.this.hasCustomReadTarget(value.getClass(), rawType)) {
                return MappingSolrConverter.this.convert(value, rawType);
            }
            Object documentValue = null;
            documentValue = value instanceof SolrInputField ? ((SolrInputField)value).getValue() : value;
            if (documentValue instanceof Collection) {
                return (T)this.readCollection((Collection)documentValue, type, parent);
            }
            if (MappingSolrConverter.this.canConvert(documentValue.getClass(), rawType)) {
                return MappingSolrConverter.this.convert(documentValue, rawType);
            }
            return (T)documentValue;
        }

        private Object readWildcard(Map<String, ?> source, SolrPersistentProperty property, Object parent) {
            WildcardPosition wildcardPosition;
            String fieldName = StringUtils.remove((String)property.getFieldName(), (String)"*");
            WildcardPosition wildcardPosition2 = wildcardPosition = StringUtils.startsWith((CharSequence)property.getFieldName(), (CharSequence)"*") ? WildcardPosition.LEADING : WildcardPosition.TRAILING;
            if (property.isMap()) {
                TypeInformation mapTypeInformation = property.getTypeInformation().getMapValueType();
                Class rawMapType = mapTypeInformation.getType();
                Class genericTargetType = mapTypeInformation.getTypeArguments() != null && !mapTypeInformation.getTypeArguments().isEmpty() ? ((TypeInformation)mapTypeInformation.getTypeArguments().get(0)).getType() : Object.class;
                HashMap values = LinkedHashMap.class.isAssignableFrom(property.getActualType()) ? new LinkedHashMap() : new HashMap();
                for (Map.Entry<String, ?> potentialMatch : source.entrySet()) {
                    if (!this.isWildcardFieldNameMatch(fieldName, wildcardPosition, potentialMatch.getKey())) continue;
                    Object value = potentialMatch.getValue();
                    if (value instanceof Iterable) {
                        if (rawMapType.isArray() || ClassUtils.isAssignable((Class)rawMapType, value.getClass())) {
                            Object[] nestedValues = new ArrayList();
                            for (Object o : (Iterable)value) {
                                nestedValues.add(this.readValue(property, o, parent, genericTargetType));
                            }
                            values.put(potentialMatch.getKey(), rawMapType.isArray() ? nestedValues.toArray() : nestedValues);
                            continue;
                        }
                        throw new IllegalArgumentException("Incompartible types found. Expected " + rawMapType + " for " + property.getName() + " with name " + property.getFieldName() + ", but found " + value.getClass());
                    }
                    if (rawMapType.isArray() || ClassUtils.isAssignable((Class)rawMapType, List.class)) {
                        Object[] singletonArrayList = new ArrayList(1);
                        singletonArrayList.add(this.readValue(property, potentialMatch.getValue(), parent, genericTargetType));
                        values.put(potentialMatch.getKey(), rawMapType.isArray() ? singletonArrayList.toArray() : singletonArrayList);
                        continue;
                    }
                    values.put(potentialMatch.getKey(), MappingSolrConverter.this.getValue(property, potentialMatch.getValue(), parent));
                }
                return values.isEmpty() ? null : values;
            }
            if (property.isCollectionLike()) {
                Class genericTargetType = property.getComponentType() != null ? property.getComponentType() : Object.class;
                Object[] values = new ArrayList();
                for (Map.Entry<String, ?> potentialMatch : source.entrySet()) {
                    if (!this.isWildcardFieldNameMatch(fieldName, wildcardPosition, potentialMatch.getKey())) continue;
                    Object value = potentialMatch.getValue();
                    if (value instanceof Iterable) {
                        for (Object o : (Iterable)value) {
                            values.add(this.readValue(property, o, parent, genericTargetType));
                        }
                        continue;
                    }
                    Object o = this.readValue(property, potentialMatch.getValue(), parent, genericTargetType);
                    if (o instanceof Collection) {
                        values.addAll((Collection)o);
                        continue;
                    }
                    values.add(o);
                }
                return values.isEmpty() ? null : (property.isArray() ? values.toArray() : values);
            }
            for (Map.Entry<String, ?> potentialMatch : source.entrySet()) {
                if (!StringUtils.contains((CharSequence)potentialMatch.getKey(), (CharSequence)fieldName)) continue;
                return MappingSolrConverter.this.getValue(property, potentialMatch.getValue(), parent);
            }
            return null;
        }

        private Object readValue(SolrPersistentProperty property, Object o, Object parent, Class<?> target) {
            Object value = MappingSolrConverter.this.getValue(property, o, parent);
            if (value == null || target == null || target.equals(Object.class)) {
                return value;
            }
            if (MappingSolrConverter.this.canConvert(value.getClass(), target)) {
                return MappingSolrConverter.this.convert(value, target);
            }
            return value;
        }

        private boolean isWildcardFieldNameMatch(String fieldname, WildcardPosition type, String candidate) {
            switch (type) {
                case LEADING: {
                    return StringUtils.endsWith((CharSequence)candidate, (CharSequence)fieldname);
                }
                case TRAILING: {
                    return StringUtils.startsWith((CharSequence)candidate, (CharSequence)fieldname);
                }
            }
            return false;
        }

        private Object readCollection(Collection<?> source, TypeInformation<?> type, Object parent) {
            Assert.notNull(type);
            Class<List> collectionType = type.getType();
            if (CollectionUtils.isEmpty(source)) {
                return source;
            }
            collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
            Collection<Object> items = type.getType().isArray() ? new ArrayList() : CollectionFactory.createCollection(collectionType, (int)source.size());
            TypeInformation componentType = type.getComponentType();
            Iterator<?> it = source.iterator();
            while (it.hasNext()) {
                items.add(this.readValue(it.next(), componentType, parent));
            }
            return type.getType().isArray() ? this.convertItemsToArrayOfType(type, items) : items;
        }

        private Object convertItemsToArrayOfType(TypeInformation<?> type, Collection<Object> items) {
            Object[] newArray = (Object[])Array.newInstance(type.getActualType().getType(), items.size());
            Object[] itemsArray = items.toArray();
            for (int i = 0; i < itemsArray.length; ++i) {
                newArray[i] = itemsArray[i];
            }
            return newArray;
        }
    }

    private static enum WildcardPosition {
        LEADING,
        TRAILING;

    }
}

