/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.Collection;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.TermsPage;

public interface SolrOperations {
    public SolrServer getSolrServer();

    public SolrPingResponse ping();

    public long count(SolrDataQuery var1);

    public UpdateResponse saveBean(Object var1);

    public UpdateResponse saveBean(Object var1, int var2);

    public UpdateResponse saveBeans(Collection<?> var1);

    public UpdateResponse saveBeans(Collection<?> var1, int var2);

    public UpdateResponse saveDocument(SolrInputDocument var1);

    public UpdateResponse saveDocument(SolrInputDocument var1, int var2);

    public UpdateResponse saveDocuments(Collection<SolrInputDocument> var1);

    public UpdateResponse saveDocuments(Collection<SolrInputDocument> var1, int var2);

    public UpdateResponse delete(SolrDataQuery var1);

    public UpdateResponse deleteById(String var1);

    public UpdateResponse deleteById(Collection<String> var1);

    public <T> T queryForObject(Query var1, Class<T> var2);

    public <T> ScoredPage<T> queryForPage(Query var1, Class<T> var2);

    public <T> FacetPage<T> queryForFacetPage(FacetQuery var1, Class<T> var2);

    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery var1, Class<T> var2);

    public TermsPage queryForTermsPage(TermsQuery var1);

    public void commit();

    public void softCommit();

    public void rollback();

    public SolrInputDocument convertBeanToSolrInputDocument(Object var1);

    public SolrConverter getConverter();

    public <T> T execute(SolrCallback<T> var1);
}

