/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

import org.springframework.data.geo.Box;
import org.springframework.data.geo.Point;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.util.Assert;

public class BoundingBox
extends Box {
    public BoundingBox(double[] first, double[] second) {
        super(first, second);
    }

    public BoundingBox(Point first, Point second) {
        super(first, second);
    }

    public static Builder startingAt(Point start) {
        return new Builder(start);
    }

    public GeoLocation getGeoLocationStart() {
        return new GeoLocation(this.getFirst().getX(), this.getFirst().getY());
    }

    public GeoLocation getGeoLocationEnd() {
        return new GeoLocation(this.getSecond().getX(), this.getSecond().getY());
    }

    public static class Builder {
        private Point start;

        public Builder(Point start) {
            Assert.notNull((Object)start);
            this.start = start;
        }

        public BoundingBox endingAt(Point end) {
            Assert.notNull((Object)end);
            return new BoundingBox(this.start, end);
        }
    }
}

