/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.geo.Point;
import org.springframework.data.solr.core.query.CalculatedField;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.Node;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryStringHolder;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class QueryParserBase<QUERYTPYE extends SolrDataQuery>
implements QueryParser {
    protected static final String CRITERIA_VALUE_SEPERATOR = " ";
    protected static final String DELIMINATOR = ":";
    protected static final String NOT = "-";
    protected static final String BOOST = "^";
    protected final GenericConversionService conversionService = new GenericConversionService();
    private final List<PredicateProcessor> critieraEntryProcessors = new ArrayList<PredicateProcessor>();
    private final PredicateProcessor defaultProcessor = new DefaultProcessor();

    public QueryParserBase() {
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(org.springframework.data.geo.Point.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Point.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.PointToStringConverter.INSTANCE);
        }
        if (VersionUtil.isJodaTimeAvailable()) {
            if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        this.critieraEntryProcessors.add(new ExpressionProcessor());
        this.critieraEntryProcessors.add(new BetweenProcessor());
        this.critieraEntryProcessors.add(new NearProcessor());
        this.critieraEntryProcessors.add(new WithinProcessor());
        this.critieraEntryProcessors.add(new FuzzyProcessor());
        this.critieraEntryProcessors.add(new SloppyProcessor());
        this.critieraEntryProcessors.add(new WildcardProcessor());
        this.critieraEntryProcessors.add(new FunctionProcessor());
    }

    @Override
    public String getQueryString(SolrDataQuery query) {
        if (query.getCriteria() == null) {
            return null;
        }
        String queryString = this.createQueryStringFromNode(query.getCriteria());
        queryString = this.prependJoin(queryString, query);
        return queryString;
    }

    @Override
    public void registerConverter(Converter<?, ?> converter) {
        this.conversionService.addConverter(converter);
    }

    public void addPredicateProcessor(PredicateProcessor processor) {
        this.critieraEntryProcessors.add(processor);
    }

    public String createQueryStringFromNode(Node node) {
        return this.createQueryStringFromNode(node, 0);
    }

    public String createQueryStringFromNode(Node node, int position) {
        StringBuilder query = new StringBuilder();
        if (position > 0) {
            query.append(node.isOr() ? " OR " : " AND ");
        }
        if (node.hasSiblings()) {
            if (!node.isRoot()) {
                query.append('(');
            }
            int i = 0;
            for (Criteria nested : node.getSiblings()) {
                query.append(this.createQueryStringFromNode(nested, i++));
            }
            if (!node.isRoot()) {
                query.append(')');
            }
        } else {
            query.append(this.createQueryFragmentForCriteria((Criteria)node));
        }
        return query.toString();
    }

    protected String createQueryStringFromCriteria(Criteria criteria) {
        return this.createQueryStringFromNode(criteria);
    }

    protected String createQueryFragmentForCriteria(Criteria part) {
        boolean singeEntryCriteria;
        Criteria criteria = part;
        StringBuilder queryFragment = new StringBuilder();
        boolean bl = singeEntryCriteria = criteria.getPredicates().size() == 1;
        if (criteria instanceof QueryStringHolder) {
            return ((QueryStringHolder)((Object)criteria)).getQueryString();
        }
        String fieldName = this.getNullsafeFieldName(criteria.getField());
        if (criteria.isNegating()) {
            fieldName = NOT + fieldName;
        }
        if (!StringUtils.isEmpty((CharSequence)fieldName) && !this.containsFunctionCriteria(criteria.getPredicates())) {
            queryFragment.append(fieldName);
            queryFragment.append(DELIMINATOR);
        }
        if (criteria.getPredicates().isEmpty()) {
            queryFragment.append("[* TO *]");
            return queryFragment.toString();
        }
        if (!singeEntryCriteria) {
            queryFragment.append("(");
        }
        CriteriaQueryStringValueProvider valueProvider = new CriteriaQueryStringValueProvider(criteria);
        while (valueProvider.hasNext()) {
            queryFragment.append(valueProvider.next());
            if (!valueProvider.hasNext()) continue;
            queryFragment.append(CRITERIA_VALUE_SEPERATOR);
        }
        if (!singeEntryCriteria) {
            queryFragment.append(")");
        }
        if (!Float.isNaN(criteria.getBoost())) {
            queryFragment.append(BOOST + criteria.getBoost());
        }
        return queryFragment.toString();
    }

    private String getNullsafeFieldName(Field field) {
        if (field == null || field.getName() == null) {
            return "";
        }
        return field.getName();
    }

    protected String createCalculatedFieldFragment(CalculatedField calculatedField) {
        return StringUtils.isNotBlank((CharSequence)calculatedField.getAlias()) ? calculatedField.getAlias() + DELIMINATOR + this.createFunctionFragment(calculatedField.getFunction()) : this.createFunctionFragment(calculatedField.getFunction());
    }

    protected String createFunctionFragment(Function function) {
        StringBuilder sb = new StringBuilder(function.getOperation());
        sb.append('(');
        if (function.hasArguments()) {
            ArrayList<Object> solrReadableArguments = new ArrayList<Object>();
            for (Object arg : function.getArguments()) {
                Assert.notNull(arg, (String)"Unable to parse 'null' within function arguments.");
                if (arg instanceof Function) {
                    solrReadableArguments.add(this.createFunctionFragment((Function)arg));
                    continue;
                }
                if (arg instanceof Criteria) {
                    solrReadableArguments.add(this.createQueryStringFromNode((Criteria)arg));
                    continue;
                }
                if (arg instanceof Field) {
                    solrReadableArguments.add(((Field)arg).getName());
                    continue;
                }
                if (arg instanceof Query) {
                    solrReadableArguments.add(this.getQueryString((Query)arg));
                    continue;
                }
                if (arg instanceof String || !this.conversionService.canConvert(arg.getClass(), String.class)) {
                    solrReadableArguments.add(arg.toString());
                    continue;
                }
                solrReadableArguments.add(this.conversionService.convert(arg, String.class));
            }
            sb.append(StringUtils.join(solrReadableArguments, (char)','));
        }
        sb.append(')');
        return sb.toString();
    }

    protected String prependJoin(String queryString, SolrDataQuery query) {
        if (query == null || query.getJoin() == null) {
            return queryString;
        }
        return "{!join from=" + query.getJoin().getFrom().getName() + " to=" + query.getJoin().getTo().getName() + "}" + queryString;
    }

    protected void appendPagination(SolrQuery query, Pageable pageable) {
        if (pageable == null) {
            return;
        }
        query.setStart(Integer.valueOf(pageable.getOffset()));
        query.setRows(Integer.valueOf(pageable.getPageSize()));
    }

    protected void appendProjectionOnFields(SolrQuery solrQuery, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        ArrayList<String> solrReadableFields = new ArrayList<String>();
        for (Field field : fields) {
            if (field instanceof CalculatedField) {
                solrReadableFields.add(this.createCalculatedFieldFragment((CalculatedField)field));
                continue;
            }
            solrReadableFields.add(field.getName());
        }
        solrQuery.setParam("fl", new String[]{StringUtils.join(solrReadableFields, (String)",")});
    }

    protected void appendDefaultOperator(SolrQuery solrQuery, Query.Operator defaultOperator) {
        if (defaultOperator != null && !Query.Operator.NONE.equals((Object)defaultOperator)) {
            solrQuery.set("q.op", new String[]{defaultOperator.asQueryStringRepresentation()});
        }
    }

    protected void appendTimeAllowed(SolrQuery solrQuery, Integer timeAllowed) {
        if (timeAllowed != null) {
            solrQuery.setTimeAllowed(timeAllowed);
        }
    }

    protected void appendDefType(SolrQuery solrQuery, String defType) {
        if (StringUtils.isNotBlank((CharSequence)defType)) {
            solrQuery.set("defType", new String[]{defType});
        }
    }

    protected void appendRequestHandler(SolrQuery solrQuery, String requestHandler) {
        if (StringUtils.isNotBlank((CharSequence)requestHandler)) {
            solrQuery.add("qt", new String[]{requestHandler});
        }
    }

    private boolean containsFunctionCriteria(Set<Criteria.Predicate> chainedCriterias) {
        for (Criteria.Predicate entry : chainedCriterias) {
            if (StringUtils.equals((CharSequence)Criteria.OperationKey.WITHIN.getKey(), (CharSequence)entry.getKey())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)Criteria.OperationKey.NEAR.getKey(), (CharSequence)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrQuery constructSolrQuery(SolrDataQuery query) {
        return this.doConstructSolrQuery(query);
    }

    public abstract SolrQuery doConstructSolrQuery(QUERYTPYE var1);

    class FunctionProcessor
    extends BasePredicateProcessor {
        FunctionProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.FUNCTION.getKey().equals(predicate.getKey());
        }

        @Override
        protected Object doProcess(Criteria.Predicate predicate, Field field) {
            return QueryParserBase.this.createFunctionFragment((Function)predicate.getValue());
        }
    }

    class WildcardProcessor
    extends BasePredicateProcessor {
        WildcardProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.CONTAINS.getKey().equals(predicate.getKey()) || Criteria.OperationKey.STARTS_WITH.getKey().equals(predicate.getKey()) || Criteria.OperationKey.ENDS_WITH.getKey().equals(predicate.getKey());
        }

        @Override
        protected Object doProcess(Criteria.Predicate predicate, Field field) {
            Object filteredValue = this.filterCriteriaValue(predicate.getValue());
            if (Criteria.OperationKey.CONTAINS.getKey().equals(predicate.getKey())) {
                return "*" + filteredValue + "*";
            }
            if (Criteria.OperationKey.STARTS_WITH.getKey().equals(predicate.getKey())) {
                return filteredValue + "*";
            }
            if (Criteria.OperationKey.ENDS_WITH.getKey().equals(predicate.getKey())) {
                return "*" + filteredValue;
            }
            return filteredValue;
        }
    }

    class SloppyProcessor
    extends BasePredicateProcessor {
        SloppyProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.SLOPPY.getKey().equals(predicate.getKey());
        }

        @Override
        protected Object doProcess(Criteria.Predicate predicate, Field field) {
            Object[] args = (Object[])predicate.getValue();
            Integer distance = (Integer)args[1];
            return this.filterCriteriaValue(args[0]) + "~" + distance;
        }
    }

    class FuzzyProcessor
    extends BasePredicateProcessor {
        FuzzyProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.FUZZY.getKey().equals(predicate.getKey());
        }

        @Override
        protected Object doProcess(Criteria.Predicate predicate, Field field) {
            Object[] args = (Object[])predicate.getValue();
            Float distance = (Float)args[1];
            return this.filterCriteriaValue(args[0]) + "~" + (distance.isNaN() ? "" : distance);
        }
    }

    class WithinProcessor
    extends NearProcessor {
        WithinProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.WITHIN.getKey().equals(predicate.getKey());
        }

        @Override
        public Object doProcess(Criteria.Predicate predicate, Field field) {
            Object[] args = (Object[])predicate.getValue();
            return this.createSpatialFunctionFragment(field.getName(), (org.springframework.data.geo.Point)args[0], (Distance)args[1], "geofilt");
        }
    }

    class NearProcessor
    extends BetweenProcessor {
        NearProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.NEAR.getKey().equals(predicate.getKey());
        }

        @Override
        public Object doProcess(Criteria.Predicate predicate, Field field) {
            String nearFragment;
            Object[] args = (Object[])predicate.getValue();
            if (args[0] instanceof Box) {
                Box box = (Box)args[0];
                nearFragment = field.getName() + ":[";
                nearFragment = nearFragment + this.createRangeFragment(box.getFirst(), box.getSecond());
                nearFragment = nearFragment + "]";
            } else {
                nearFragment = this.createSpatialFunctionFragment(field.getName(), (org.springframework.data.geo.Point)args[0], (Distance)args[1], "bbox");
            }
            return nearFragment;
        }

        protected String createSpatialFunctionFragment(String fieldName, org.springframework.data.geo.Point location, Distance distance, String function) {
            String spatialFragment = "{!" + function + QueryParserBase.CRITERIA_VALUE_SEPERATOR + "pt" + "=";
            spatialFragment = spatialFragment + this.filterCriteriaValue(location);
            spatialFragment = spatialFragment + " sfield=" + fieldName;
            spatialFragment = spatialFragment + " d=" + this.filterCriteriaValue(distance);
            spatialFragment = spatialFragment + "}";
            return spatialFragment;
        }
    }

    class BetweenProcessor
    extends BasePredicateProcessor {
        private static final String RANGE_OPERATOR = " TO ";

        BetweenProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.BETWEEN.getKey().equals(predicate.getKey());
        }

        @Override
        public Object doProcess(Criteria.Predicate predicate, Field field) {
            Object[] args = (Object[])predicate.getValue();
            String rangeFragment = (Boolean)args[2] != false ? "[" : "{";
            rangeFragment = rangeFragment + this.createRangeFragment(args[0], args[1]);
            rangeFragment = rangeFragment + ((Boolean)args[3] != false ? "]" : "}");
            return rangeFragment;
        }

        protected String createRangeFragment(Object rangeStart, Object rangeEnd) {
            String rangeFragment = "";
            rangeFragment = rangeFragment + (rangeStart != null ? this.filterCriteriaValue(rangeStart) : "*");
            rangeFragment = rangeFragment + RANGE_OPERATOR;
            rangeFragment = rangeFragment + (rangeEnd != null ? this.filterCriteriaValue(rangeEnd) : "*");
            return rangeFragment;
        }
    }

    class ExpressionProcessor
    extends BasePredicateProcessor {
        ExpressionProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return Criteria.OperationKey.EXPRESSION.getKey().equals(predicate.getKey());
        }

        @Override
        public Object doProcess(Criteria.Predicate predicate, Field field) {
            return predicate.getValue().toString();
        }
    }

    class DefaultProcessor
    extends BasePredicateProcessor {
        DefaultProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.Predicate predicate) {
            return true;
        }

        @Override
        public Object doProcess(Criteria.Predicate predicate, Field field) {
            return this.filterCriteriaValue(predicate.getValue());
        }
    }

    abstract class BasePredicateProcessor
    implements PredicateProcessor {
        protected static final String DOUBLEQUOTE = "\"";
        protected final String[] RESERVED_CHARS = new String[]{"\"", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "~", "*", "?", ":", "\\"};
        protected String[] RESERVED_CHARS_REPLACEMENT = new String[]{"\\\"", "\\+", "\\-", "\\&\\&", "\\|\\|", "\\!", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\^", "\\~", "\\*", "\\?", "\\:", "\\\\"};

        BasePredicateProcessor() {
        }

        @Override
        public Object process(Criteria.Predicate predicate, Field field) {
            if (predicate == null || predicate.getValue() == null) {
                return null;
            }
            return this.doProcess(predicate, field);
        }

        protected Object filterCriteriaValue(Object criteriaValue) {
            if (!(criteriaValue instanceof String)) {
                if (QueryParserBase.this.conversionService.canConvert(criteriaValue.getClass(), String.class)) {
                    return QueryParserBase.this.conversionService.convert(criteriaValue, String.class);
                }
                return criteriaValue;
            }
            String value = this.escapeCriteriaValue((String)criteriaValue);
            return this.processWhiteSpaces(value);
        }

        private String escapeCriteriaValue(String criteriaValue) {
            return StringUtils.replaceEach((String)criteriaValue, (String[])this.RESERVED_CHARS, (String[])this.RESERVED_CHARS_REPLACEMENT);
        }

        private String processWhiteSpaces(String criteriaValue) {
            if (StringUtils.contains((CharSequence)criteriaValue, (CharSequence)QueryParserBase.CRITERIA_VALUE_SEPERATOR)) {
                return DOUBLEQUOTE + criteriaValue + DOUBLEQUOTE;
            }
            return criteriaValue;
        }

        protected abstract Object doProcess(Criteria.Predicate var1, Field var2);
    }

    class CriteriaQueryStringValueProvider
    implements Iterator<String> {
        private final Criteria criteria;
        private Iterator<Criteria.Predicate> delegate;

        CriteriaQueryStringValueProvider(Criteria criteria) {
            Assert.notNull((Object)criteria, (String)"Unable to provide values for 'null' criteria");
            this.criteria = criteria;
            this.delegate = criteria.getPredicates().iterator();
        }

        private <T> T getPredicateValue(Criteria.Predicate predicate) {
            PredicateProcessor processor = this.findMatchingProcessor(predicate);
            return (T)processor.process(predicate, this.criteria.getField());
        }

        private PredicateProcessor findMatchingProcessor(Criteria.Predicate predicate) {
            for (PredicateProcessor processor : QueryParserBase.this.critieraEntryProcessors) {
                if (!processor.canProcess(predicate)) continue;
                return processor;
            }
            return QueryParserBase.this.defaultProcessor;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public String next() {
            Object o = this.getPredicateValue(this.delegate.next());
            String s = o != null ? o.toString() : null;
            return s;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static interface PredicateProcessor {
        public boolean canProcess(Criteria.Predicate var1);

        public Object process(Criteria.Predicate var1, Field var2);
    }
}

