/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FieldWithQueryParameters;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.QueryParameterImpl;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimplePivotField;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FacetOptions {
    public static final int DEFAULT_FACET_MIN_COUNT = 1;
    public static final int DEFAULT_FACET_LIMIT = 10;
    public static final FacetSort DEFAULT_FACET_SORT = FacetSort.COUNT;
    private List<Field> facetOnFields = new ArrayList<Field>(1);
    private List<PivotField> facetOnPivotFields = new ArrayList<PivotField>(0);
    private List<SolrDataQuery> facetQueries = new ArrayList<SolrDataQuery>(0);
    private int facetMinCount = 1;
    private int facetLimit = 10;
    private String facetPrefix;
    private FacetSort facetSort = DEFAULT_FACET_SORT;
    private Pageable pageable;

    public FacetOptions() {
    }

    public FacetOptions(String ... fieldnames) {
        Assert.notNull((Object)fieldnames, (String)"Fields must not be null.");
        Assert.noNullElements((Object[])fieldnames, (String)"Cannot facet on null fieldname.");
        for (String fieldname : fieldnames) {
            this.addFacetOnField(fieldname);
        }
    }

    public FacetOptions(Field ... fields) {
        Assert.notNull((Object)fields, (String)"Fields must not be null.");
        Assert.noNullElements((Object[])fields, (String)"Cannot facet on null field.");
        for (Field field : fields) {
            this.addFacetOnField(field);
        }
    }

    public FacetOptions(SolrDataQuery ... facetQueries) {
        Assert.notNull((Object)facetQueries, (String)"Facet Queries must not be null.");
        Assert.noNullElements((Object[])facetQueries, (String)"Cannot facet on null query.");
        this.facetQueries.addAll(Arrays.asList(facetQueries));
    }

    public final FacetOptions addFacetOnField(Field field) {
        Assert.notNull((Object)field, (String)"Cannot facet on null field.");
        Assert.hasText((String)field.getName(), (String)"Cannot facet on field with null/empty fieldname.");
        this.facetOnFields.add(field);
        return this;
    }

    public final FacetOptions addFacetOnField(String fieldname) {
        this.addFacetOnField(new SimpleField(fieldname));
        return this;
    }

    public final FacetOptions addFacetOnPivot(Field ... fields) {
        Assert.notNull((Object)fields, (String)"Pivot Facets must not be null.");
        for (Field field : fields) {
            Assert.notNull((Object)field, (String)"Cannot facet on null field.");
            Assert.hasText((String)field.getName(), (String)"Cannot facet on field with null/empty fieldname.");
        }
        List<Field> list = Arrays.asList(fields);
        this.facetOnPivotFields.add(new SimplePivotField(list));
        return this;
    }

    public final FacetOptions addFacetOnPivot(String ... fieldnames) {
        Assert.state((fieldnames.length > 1 ? 1 : 0) != 0, (String)"2 or more fields required for pivot facets");
        for (String fieldname : fieldnames) {
            Assert.hasText((String)fieldname, (String)"Fieldnames must not contain null/empty values");
        }
        this.facetOnPivotFields.add(new SimplePivotField(fieldnames));
        return this;
    }

    public final FacetOptions addFacetOnFlieldnames(Collection<String> fieldnames) {
        Assert.notNull(fieldnames);
        for (String fieldname : fieldnames) {
            this.addFacetOnField(fieldname);
        }
        return this;
    }

    public final FacetOptions addFacetQuery(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Facet Query must not be null.");
        this.facetQueries.add(query);
        return this;
    }

    public List<SolrDataQuery> getFacetQueries() {
        return Collections.unmodifiableList(this.facetQueries);
    }

    public FacetOptions setFacetMinCount(int minCount) {
        this.facetMinCount = Math.max(0, minCount);
        return this;
    }

    public FacetOptions setFacetLimit(int rowsToReturn) {
        this.facetLimit = Math.max(1, rowsToReturn);
        return this;
    }

    public FacetOptions setFacetSort(FacetSort facetSort) {
        Assert.notNull((Object)((Object)facetSort), (String)"FacetSort must not be null.");
        this.facetSort = facetSort;
        return this;
    }

    public final List<Field> getFacetOnFields() {
        return Collections.unmodifiableList(this.facetOnFields);
    }

    public final List<PivotField> getFacetOnPivots() {
        return Collections.unmodifiableList(this.facetOnPivotFields);
    }

    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public int getFacetLimit() {
        return this.facetLimit;
    }

    public FacetSort getFacetSort() {
        return this.facetSort;
    }

    public Pageable getPageable() {
        return this.pageable != null ? this.pageable : new PageRequest(0, this.facetLimit);
    }

    public FacetOptions setPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public String getFacetPrefix() {
        return this.facetPrefix;
    }

    public FacetOptions setFacetPrefix(String facetPrefix) {
        this.facetPrefix = facetPrefix;
        return this;
    }

    public boolean hasFields() {
        return !this.facetOnFields.isEmpty() || !this.facetOnPivotFields.isEmpty();
    }

    public boolean hasFacetQueries() {
        return !this.facetQueries.isEmpty();
    }

    public boolean hasPivotFields() {
        return !this.facetOnPivotFields.isEmpty();
    }

    public boolean hasFacets() {
        return this.hasFields() || this.hasFacetQueries() || this.hasPivotFields();
    }

    public boolean hasFacetPrefix() {
        return StringUtils.hasText((String)this.facetPrefix);
    }

    public Collection<FieldWithFacetParameters> getFieldsWithParameters() {
        return CollectionUtils.select(this.facetOnFields, (Predicate)new IsFieldWithFacetParametersInstancePredicate());
    }

    public static class FieldWithFacetParameters
    extends FieldWithQueryParameters<FacetParameter> {
        private FacetSort sort;

        public FieldWithFacetParameters(String name) {
            super(name);
        }

        public FieldWithFacetParameters setPrefix(String prefix) {
            this.addFacetParameter("facet.prefix", prefix);
            return this;
        }

        public String getPrefix() {
            return (String)this.getQueryParameterValue("facet.prefix");
        }

        public FieldWithFacetParameters setSort(FacetSort sort) {
            this.sort = sort;
            return this;
        }

        public FacetSort getSort() {
            return this.sort;
        }

        public FieldWithFacetParameters setLimit(Integer limit) {
            this.addFacetParameter("facet.limit", Math.max(0, limit), true);
            return this;
        }

        public Integer getLimit() {
            return (Integer)this.getQueryParameterValue("facet.limit");
        }

        public FieldWithFacetParameters setOffset(Integer offset) {
            this.addFacetParameter("facet.offset", offset, true);
            return this;
        }

        public Integer getOffset() {
            return (Integer)this.getQueryParameterValue("facet.offset");
        }

        public FieldWithFacetParameters setMinCount(Integer minCount) {
            this.addFacetParameter("facet.mincount", Math.max(0, minCount), true);
            return this;
        }

        public Integer getMinCount() {
            return (Integer)this.getQueryParameterValue("facet.mincount");
        }

        public FieldWithFacetParameters setMissing(Boolean missing) {
            this.addFacetParameter("facet.missing", missing, true);
            return this;
        }

        public Boolean getMissing() {
            return (Boolean)this.getQueryParameterValue("facet.missing");
        }

        public FieldWithFacetParameters setMethod(String method) {
            this.addFacetParameter("facet.method", method, true);
            return this;
        }

        public String getMethod() {
            return (String)this.getQueryParameterValue("facet.method");
        }

        public FieldWithFacetParameters addFacetParameter(String parameterName, Object value) {
            return this.addFacetParameter(parameterName, value, false);
        }

        protected FieldWithFacetParameters addFacetParameter(String parameterName, Object value, boolean removeIfValueIsNull) {
            if (removeIfValueIsNull && value == null) {
                this.removeQueryParameter(parameterName);
                return this;
            }
            return this.addFacetParameter(new FacetParameter(parameterName, value));
        }

        public FieldWithFacetParameters addFacetParameter(FacetParameter parameter) {
            this.addQueryParameter(parameter);
            return this;
        }
    }

    public static class FacetParameter
    extends QueryParameterImpl {
        public FacetParameter(String parameter, Object value) {
            super(parameter, value);
        }
    }

    private static class IsFieldWithFacetParametersInstancePredicate
    implements Predicate {
        private IsFieldWithFacetParametersInstancePredicate() {
        }

        public boolean evaluate(Object object) {
            return object instanceof FieldWithFacetParameters;
        }
    }

    public static enum FacetSort {
        COUNT,
        INDEX;

    }
}

