/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.util.Assert;

public class GeoHashFunction
extends AbstractFunction {
    private static final String OPERATION = "geohash";

    private GeoHashFunction(GeoLocation location) {
        super(Arrays.asList(location));
    }

    public static GeoHashFunction geohash(GeoLocation location) {
        Assert.notNull((Object)location, (String)"Location for geohash function must not be 'null'");
        return new GeoHashFunction(location);
    }

    public static GeoHashFunction geohash(double latitude, double longitude) {
        return GeoHashFunction.geohash(new GeoLocation(latitude, longitude));
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

