/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.UncategorizedSolrException;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.QueryParsers;
import org.springframework.data.solr.core.ResultHelper;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.SolrResultPage;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.data.solr.core.query.result.TermsResultPage;
import org.springframework.data.solr.server.SolrServerFactory;
import org.springframework.data.solr.server.support.HttpSolrServerFactory;
import org.springframework.util.Assert;

public class SolrTemplate
implements SolrOperations,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrTemplate.class);
    private static final PersistenceExceptionTranslator EXCEPTION_TRANSLATOR = new SolrExceptionTranslator();
    private final QueryParsers queryParsers = new QueryParsers();
    private ApplicationContext applicationContext;
    private String solrCore;
    private static final List<String> ITERABLE_CLASSES = new ArrayList<String>(){
        {
            this.add(List.class.getName());
            this.add(Collection.class.getName());
            this.add(Iterator.class.getName());
        }
    };
    private SolrServerFactory solrServerFactory;
    private SolrConverter solrConverter;

    public SolrTemplate(SolrServer solrServer) {
        this(solrServer, null);
    }

    public SolrTemplate(SolrServer solrServer, String core) {
        this(new HttpSolrServerFactory(solrServer, core));
        this.solrCore = core;
    }

    public SolrTemplate(SolrServerFactory solrServerFactory) {
        this(solrServerFactory, null);
    }

    public SolrTemplate(SolrServerFactory solrServerFactory, SolrConverter solrConverter) {
        Assert.notNull((Object)solrServerFactory, (String)"SolrServerFactory must not be 'null'.");
        Assert.notNull((Object)solrServerFactory.getSolrServer(), (String)"SolrServerFactory has to return a SolrServer.");
        this.solrServerFactory = solrServerFactory;
        this.solrConverter = solrConverter == null ? this.getDefaultSolrConverter() : solrConverter;
    }

    @Override
    public <T> T execute(SolrCallback<T> action) {
        Assert.notNull(action);
        try {
            SolrServer solrServer = this.getSolrServer();
            return action.doInSolr(solrServer);
        }
        catch (Exception e) {
            DataAccessException resolved = SolrTemplate.getExceptionTranslator().translateExceptionIfPossible(new RuntimeException(e.getMessage(), e));
            throw resolved == null ? new UncategorizedSolrException(e.getMessage(), e) : resolved;
        }
    }

    @Override
    public SolrPingResponse ping() {
        return this.execute(new SolrCallback<SolrPingResponse>(){

            @Override
            public SolrPingResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.ping();
            }
        });
    }

    @Override
    public long count(final SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        return this.execute(new SolrCallback<Long>(){

            @Override
            public Long doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                SolrQuery solrQuery = SolrTemplate.this.queryParsers.getForClass(query.getClass()).constructSolrQuery(query);
                solrQuery.setStart(Integer.valueOf(0));
                solrQuery.setRows(Integer.valueOf(0));
                return solrServer.query((SolrParams)solrQuery).getResults().getNumFound();
            }
        });
    }

    @Override
    public UpdateResponse saveBean(Object obj) {
        return this.saveBean(obj, -1);
    }

    @Override
    public UpdateResponse saveBean(final Object objectToAdd, final int commitWithinMs) {
        this.assertNoCollection(objectToAdd);
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.add(SolrTemplate.this.convertBeanToSolrInputDocument(objectToAdd), commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveBeans(Collection<?> beans) {
        return this.saveBeans(beans, -1);
    }

    @Override
    public UpdateResponse saveBeans(final Collection<?> beansToAdd, final int commitWithinMs) {
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.add(SolrTemplate.this.convertBeansToSolrInputDocuments(beansToAdd), commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveDocument(SolrInputDocument document) {
        return this.saveDocument(document, -1);
    }

    @Override
    public UpdateResponse saveDocument(final SolrInputDocument documentToAdd, final int commitWithinMs) {
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.add(documentToAdd, commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveDocuments(Collection<SolrInputDocument> documents) {
        return this.saveDocuments(documents, -1);
    }

    @Override
    public UpdateResponse saveDocuments(final Collection<SolrInputDocument> documentsToAdd, final int commitWithinMs) {
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.add(documentsToAdd, commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse delete(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        final String queryString = this.queryParsers.getForClass(query.getClass()).getQueryString(query);
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.deleteByQuery(queryString);
            }
        });
    }

    @Override
    public UpdateResponse deleteById(final String id) {
        Assert.notNull((Object)id, (String)"Cannot delete 'null' id.");
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.deleteById(id);
            }
        });
    }

    @Override
    public UpdateResponse deleteById(Collection<String> ids) {
        Assert.notNull(ids, (String)"Cannot delete 'null' collection.");
        final ArrayList<String> toBeDeleted = new ArrayList<String>(ids);
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.deleteById(toBeDeleted);
            }
        });
    }

    @Override
    public <T> T queryForObject(Query query, Class<T> clazz) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        query.setPageRequest((Pageable)new PageRequest(0, 1));
        QueryResponse response = this.query(query);
        if (response.getResults().size() > 0) {
            if (response.getResults().size() > 1) {
                LOGGER.warn("More than 1 result found for singe result query ('{}'), returning first entry in list");
            }
            return this.convertSolrDocumentListToBeans(response.getResults(), clazz).get(0);
        }
        return null;
    }

    @Override
    public <T> Page<T> queryForPage(Query query, Class<T> clazz) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryResponse response = this.query(query);
        List<T> beans = this.convertQueryResponseToBeans(response, clazz);
        return new SolrResultPage<T>(beans, query.getPageRequest(), response.getResults().getNumFound());
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(FacetQuery query, Class<T> clazz) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryResponse response = this.query(query);
        List<T> beans = this.convertQueryResponseToBeans(response, clazz);
        SolrResultPage<T> page = new SolrResultPage<T>(beans, query.getPageRequest(), response.getResults().getNumFound());
        page.addAllFacetFieldResultPages(ResultHelper.convertFacetQueryResponseToFacetPageMap(query, response));
        page.addAllFacetPivotFieldResult(ResultHelper.convertFacetQueryResponseToFacetPivotMap(query, response));
        page.setFacetQueryResultPage(ResultHelper.convertFacetQueryResponseToFacetQueryResult(query, response));
        return page;
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery query, Class<T> clazz) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryResponse response = this.query(query);
        List<T> beans = this.convertQueryResponseToBeans(response, clazz);
        SolrResultPage<T> page = new SolrResultPage<T>(beans, query.getPageRequest(), response.getResults().getNumFound());
        ResultHelper.convertAndAddHighlightQueryResponseToResultPage(response, page);
        return page;
    }

    @Override
    public TermsPage queryForTermsPage(TermsQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        QueryResponse response = this.query(query);
        TermsResultPage page = new TermsResultPage();
        page.addAllTerms(ResultHelper.convertTermsQueryResponseToTermsMap(response));
        return page;
    }

    final QueryResponse query(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'");
        SolrQuery solrQuery = this.queryParsers.getForClass(query.getClass()).constructSolrQuery(query);
        LOGGER.debug("Executing query '" + solrQuery + "' against solr.");
        return this.executeSolrQuery(solrQuery);
    }

    final QueryResponse executeSolrQuery(final SolrQuery solrQuery) {
        return this.execute(new SolrCallback<QueryResponse>(){

            @Override
            public QueryResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.query((SolrParams)solrQuery);
            }
        });
    }

    @Override
    public void commit() {
        this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.commit();
            }
        });
    }

    @Override
    public void softCommit() {
        if (VersionUtil.isSolr3XAvailable()) {
            throw new UnsupportedOperationException("Soft commit is not available for solr version lower than 4.x - Please check your depdendencies.");
        }
        this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.commit(true, true, true);
            }
        });
    }

    @Override
    public void rollback() {
        this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrServer solrServer) throws SolrServerException, IOException {
                return solrServer.rollback();
            }
        });
    }

    @Override
    public SolrInputDocument convertBeanToSolrInputDocument(Object bean) {
        if (bean instanceof SolrInputDocument) {
            return (SolrInputDocument)bean;
        }
        SolrInputDocument document = new SolrInputDocument();
        this.getConverter().write(bean, document);
        return document;
    }

    private Collection<SolrInputDocument> convertBeansToSolrInputDocuments(Iterable<?> beans) {
        if (beans == null) {
            return Collections.emptyList();
        }
        ArrayList<SolrInputDocument> resultList = new ArrayList<SolrInputDocument>();
        for (Object bean : beans) {
            resultList.add(this.convertBeanToSolrInputDocument(bean));
        }
        return resultList;
    }

    public <T> List<T> convertQueryResponseToBeans(QueryResponse response, Class<T> targetClass) {
        return response != null ? this.convertSolrDocumentListToBeans(response.getResults(), targetClass) : Collections.emptyList();
    }

    public <T> List<T> convertSolrDocumentListToBeans(SolrDocumentList documents, Class<T> targetClass) {
        if (documents == null) {
            return Collections.emptyList();
        }
        return this.getConverter().read(documents, targetClass);
    }

    public <T> T convertSolrDocumentToBean(SolrDocument document, Class<T> targetClass) {
        return (T)this.getConverter().read(targetClass, document);
    }

    protected void assertNoCollection(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Collections are not supported for this operation");
        }
    }

    private final SolrConverter getDefaultSolrConverter() {
        MappingSolrConverter converter = new MappingSolrConverter((MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty>)new SimpleSolrMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    @Override
    public final SolrServer getSolrServer() {
        return this.solrServerFactory.getSolrServer(this.solrCore);
    }

    @Override
    public SolrConverter getConverter() {
        return this.solrConverter;
    }

    public static PersistenceExceptionTranslator getExceptionTranslator() {
        return EXCEPTION_TRANSLATOR;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void registerQueryParser(Class<? extends SolrDataQuery> clazz, QueryParser queryParser) {
        this.queryParsers.registerParser(clazz, queryParser);
    }

    public void setSolrConverter(SolrConverter solrConverter) {
        this.solrConverter = solrConverter;
    }

    public String getSolrCore() {
        return this.solrCore;
    }

    public void setSolrCore(String solrCore) {
        this.solrCore = solrCore;
    }

    public void afterPropertiesSet() {
        if (this.solrConverter == null) {
            this.solrConverter = this.getDefaultSolrConverter();
        }
        this.registerPersistenceExceptionTranslator();
    }

    private void registerPersistenceExceptionTranslator() {
        if (this.applicationContext != null && this.applicationContext.getBeansOfType(PersistenceExceptionTranslator.class).isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().registerSingleton("solrExceptionTranslator", (Object)EXCEPTION_TRANSLATOR);
        }
    }
}

