/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.server.support.SolrServerFactoryBase;
import org.springframework.data.solr.server.support.SolrServerUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MulticoreSolrServerFactory
extends SolrServerFactoryBase {
    private boolean createMissingSolrServer = true;
    private Map<String, SolrServer> serverMap = new LinkedHashMap<String, SolrServer>();

    protected MulticoreSolrServerFactory() {
    }

    public MulticoreSolrServerFactory(SolrServer solrServer) {
        this(solrServer, Collections.emptyList());
    }

    public MulticoreSolrServerFactory(SolrServer solrServer, String ... cores) {
        this(solrServer, cores != null ? Arrays.asList(cores) : Collections.emptyList());
    }

    public MulticoreSolrServerFactory(SolrServer solrServer, List<String> cores) {
        super(solrServer);
        for (String core : cores) {
            this.addSolrServerForCore(this.createServerForCore(solrServer, core), core);
        }
    }

    @Override
    public SolrServer getSolrServer(String core) {
        if (!StringUtils.hasText((String)core)) {
            return this.getSolrServer();
        }
        if (this.createMissingSolrServer && !this.serverMap.containsKey(core)) {
            this.serverMap.put(core, this.createServerForCore(this.getSolrServer(), core));
        }
        return this.serverMap.get(core);
    }

    public void addSolrServerForCore(SolrServer solrServer, String core) {
        this.serverMap.put(core, solrServer);
    }

    public void removeSolrSever(String core) {
        if (this.serverMap.containsKey(core)) {
            this.destroy(this.serverMap.remove(core));
        }
    }

    public SolrServer getSolrServer(Class<?> clazz) {
        Assert.notNull(clazz);
        String coreName = MulticoreSolrServerFactory.getShortClassName(clazz);
        SolrDocument annotation = (SolrDocument)AnnotationUtils.findAnnotation(clazz, SolrDocument.class);
        if (annotation != null && StringUtils.hasText((String)annotation.solrCoreName())) {
            coreName = annotation.solrCoreName();
        }
        return this.getSolrServer(coreName);
    }

    protected static String getShortClassName(Class<?> clazz) {
        String shortName = ClassUtils.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        return dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
    }

    @Override
    public List<String> getCores() {
        return new ArrayList<String>(this.serverMap.keySet());
    }

    @Override
    public void destroy() {
        super.destroy();
        for (SolrServer server : this.serverMap.values()) {
            this.destroy(server);
        }
    }

    protected SolrServer createServerForCore(SolrServer reference, String core) {
        if (StringUtils.hasText((String)core)) {
            return SolrServerUtils.clone(reference, core);
        }
        return reference;
    }

    public boolean isCreateMissingSolrServer() {
        return this.createMissingSolrServer;
    }

    public void setCreateMissingSolrServer(boolean createMissingSolrServer) {
        this.createMissingSolrServer = createMissingSolrServer;
    }
}

