/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.repository.support.SolrRepositoryFactory;
import org.springframework.util.Assert;

public class SolrRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private SolrOperations operations;

    public void setSolrOperations(SolrOperations operations) {
        Assert.notNull((Object)operations);
        this.operations = operations;
    }

    protected SolrOperations getSolrOperations() {
        return this.operations;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operations, (String)"SolrOperations must be configured!");
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        return new SolrRepositoryFactory(this.operations);
    }
}

