/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.repository.Facet;
import org.springframework.data.solr.repository.Highlight;
import org.springframework.data.solr.repository.Query;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrParameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SolrQueryMethod
extends QueryMethod {
    private final SolrEntityInformation<?, ?> entityInformation;
    private Method method;

    public SolrQueryMethod(Method method, RepositoryMetadata metadata, SolrEntityInformationCreator solrInformationCreator) {
        super(method, metadata);
        this.method = method;
        this.entityInformation = solrInformationCreator.getEntityInformation(metadata.getReturnedDomainClass(method));
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public boolean hasQueryAnnotation() {
        return this.method.getAnnotation(Query.class) != null;
    }

    String getAnnotatedQuery() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "value");
    }

    public boolean hasAnnotatedNamedQueryName() {
        return this.getAnnotatedNamedQueryName() != null;
    }

    String getAnnotatedNamedQueryName() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "name");
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasProjectionFields() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getProjectionFields());
        }
        return false;
    }

    public List<String> getProjectionFields() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "fields");
    }

    public Integer getTimeAllowed() {
        if (this.hasQueryAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getQueryAnnotation(), "timeAllowed");
        }
        return null;
    }

    public boolean isFacetQuery() {
        return this.hasFacetFields() || this.hasFacetQueries();
    }

    public boolean hasFacetFields() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetFields());
        }
        return false;
    }

    private boolean hasFacetAnnotation() {
        return this.getFacetAnnotation() != null;
    }

    public List<String> getFacetFields() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "fields");
    }

    public List<String> getFacetQueries() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "queries");
    }

    public boolean hasFacetQueries() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetQueries());
        }
        return false;
    }

    private Annotation getFacetAnnotation() {
        return this.method.getAnnotation(Facet.class);
    }

    public Integer getFacetLimit() {
        return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"limit");
    }

    public Integer getFacetMinCount() {
        return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"minCount");
    }

    public String getFacetPrefix() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getFacetAnnotation(), "prefix");
    }

    public boolean hasFilterQuery() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFilterQueries());
        }
        return false;
    }

    private Annotation getHighlightAnnotation() {
        return this.method.getAnnotation(Highlight.class);
    }

    private boolean hasHighlightAnnotation() {
        return this.getHighlightAnnotation() != null;
    }

    public boolean isHighlightQuery() {
        return this.hasHighlightAnnotation();
    }

    public List<String> getHighlightFieldNames() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValuesAsStringList(this.getHighlightAnnotation(), "fields");
        }
        return Collections.emptyList();
    }

    public String getHighlightQuery() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "query");
        }
        return null;
    }

    public Integer getHighlighSnipplets() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "snipplets");
        }
        return null;
    }

    public Integer getHighlightFragsize() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "fragsize");
        }
        return null;
    }

    public String getHighlightFormatter() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "formatter");
        }
        return null;
    }

    public String getHighlightPrefix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "prefix");
        }
        return null;
    }

    public String getHighlightPostfix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "postfix");
        }
        return null;
    }

    public boolean hasHighlightFields() {
        return !this.getHighlightFieldNames().isEmpty();
    }

    List<String> getFilterQueries() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "filters");
    }

    public Query.Operator getDefaultOperator() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defaultOperator();
        }
        return Query.Operator.NONE;
    }

    public String getDefType() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defType();
        }
        return null;
    }

    public String getRequestHandler() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().requestHandler();
        }
        return null;
    }

    private String getAnnotationValueAsStringOrNullIfBlank(Annotation annotation, String attributeName) {
        String value = (String)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        return StringUtils.hasText((String)value) ? value : null;
    }

    private Integer getAnnotationValueAsIntOrNullIfNegative(Annotation annotation, String attributeName) {
        Integer timeAllowed = (Integer)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        if (timeAllowed != null && timeAllowed > 0) {
            return timeAllowed;
        }
        return null;
    }

    private List<String> getAnnotationValuesAsStringList(Annotation annotation, String attribute) {
        String[] values = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        if (values.length > 1 || values.length == 1 && StringUtils.hasText((String)values[0])) {
            return CollectionUtils.arrayToList((Object)values);
        }
        return Collections.emptyList();
    }

    public SolrEntityInformation<?, ?> getEntityInformation() {
        return this.entityInformation;
    }

    public String getNamedQueryName() {
        if (!this.hasAnnotatedNamedQueryName()) {
            return super.getNamedQueryName();
        }
        return this.getAnnotatedNamedQueryName();
    }

    protected SolrParameters createParameters(Method method) {
        return new SolrParameters(method);
    }

    public SolrParameters getParameters() {
        return (SolrParameters)super.getParameters();
    }
}

