/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Join;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;

class AbstractQuery {
    private Criteria criteria;
    private Join join;
    private String requestHandler;

    AbstractQuery() {
    }

    AbstractQuery(Criteria criteria) {
        this.addCriteria(criteria);
    }

    public final <T extends SolrDataQuery> T addCriteria(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot add null criteria.");
        if (!(criteria instanceof SimpleStringCriteria)) {
            Assert.notNull((Object)criteria.getField(), (String)"Cannot add criteria for null field.");
            Assert.hasText((String)criteria.getField().getName(), (String)"Criteria.field.name must not be null/empty.");
        }
        if (this.criteria == null) {
            this.criteria = criteria;
        } else {
            this.criteria.and(criteria);
        }
        return (T)((SolrDataQuery)((Object)this));
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setJoin(Join join) {
        this.join = join;
    }

    public Join getJoin() {
        return this.join;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }
}

