/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.BoundingBox;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryStringHolder;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class QueryParserBase<QUERYTPYE extends SolrDataQuery>
implements QueryParser {
    protected static final String CRITERIA_VALUE_SEPERATOR = " ";
    protected static final String DELIMINATOR = ":";
    protected static final String NOT = "-";
    protected static final String BOOST = "^";
    protected final GenericConversionService conversionService = new GenericConversionService();
    private final List<CriteriaEntryProcessor> critieraEntryProcessors = new ArrayList<CriteriaEntryProcessor>();
    private final CriteriaEntryProcessor defaultProcessor = new DefaultProcessor();

    public QueryParserBase() {
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(GeoLocation.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
        if (VersionUtil.isJodaTimeAvailable()) {
            if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        this.critieraEntryProcessors.add(new ExpressionProcessor());
        this.critieraEntryProcessors.add(new BetweenProcessor());
        this.critieraEntryProcessors.add(new NearProcessor());
        this.critieraEntryProcessors.add(new WithinProcessor());
        this.critieraEntryProcessors.add(new FuzzyProcessor());
        this.critieraEntryProcessors.add(new SloppyProcessor());
        this.critieraEntryProcessors.add(new WildcardProcessor());
    }

    @Override
    public String getQueryString(SolrDataQuery query) {
        if (query.getCriteria() == null) {
            return null;
        }
        String queryString = this.createQueryStringFromCriteria(query.getCriteria());
        queryString = this.prependJoin(queryString, query);
        return queryString;
    }

    @Override
    public void registerConverter(Converter<?, ?> converter) {
        this.conversionService.addConverter(converter);
    }

    public void addCriteriaEntryProcessor(CriteriaEntryProcessor processor) {
        this.critieraEntryProcessors.add(processor);
    }

    protected String createQueryStringFromCriteria(Criteria criteria) {
        StringBuilder query = new StringBuilder("");
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = chainIterator.next();
            query.append(this.createQueryFragmentForCriteria(chainedCriteria));
            if (!chainIterator.hasNext()) continue;
            query.append(chainIterator.next().getConjunctionOperator());
            chainIterator.previous();
        }
        return query.toString();
    }

    protected String createQueryFragmentForCriteria(Criteria criteria) {
        boolean singeEntryCriteria;
        StringBuilder queryFragment = new StringBuilder();
        boolean bl = singeEntryCriteria = criteria.getCriteriaEntries().size() == 1;
        if (criteria.getField() != null) {
            String fieldName = criteria.getField().getName();
            if (criteria.isNegating()) {
                fieldName = NOT + fieldName;
            }
            if (!this.containsFunctionCriteria(criteria.getCriteriaEntries())) {
                queryFragment.append(fieldName);
                queryFragment.append(DELIMINATOR);
            }
            if (!singeEntryCriteria) {
                queryFragment.append("(");
            }
            CriteriaQueryStringValueProvider valueProvider = new CriteriaQueryStringValueProvider(criteria);
            while (valueProvider.hasNext()) {
                queryFragment.append(valueProvider.next());
                if (!valueProvider.hasNext()) continue;
                queryFragment.append(CRITERIA_VALUE_SEPERATOR);
            }
            if (!singeEntryCriteria) {
                queryFragment.append(")");
            }
            if (!Float.isNaN(criteria.getBoost())) {
                queryFragment.append(BOOST + criteria.getBoost());
            }
        } else if (criteria instanceof QueryStringHolder) {
            return ((QueryStringHolder)((Object)criteria)).getQueryString();
        }
        return queryFragment.toString();
    }

    protected String prependJoin(String queryString, SolrDataQuery query) {
        if (query == null || query.getJoin() == null) {
            return queryString;
        }
        return "{!join from=" + query.getJoin().getFrom().getName() + " to=" + query.getJoin().getTo().getName() + "}" + queryString;
    }

    protected void appendPagination(SolrQuery query, Pageable pageable) {
        if (pageable == null) {
            return;
        }
        query.setStart(Integer.valueOf(pageable.getOffset()));
        query.setRows(Integer.valueOf(pageable.getPageSize()));
    }

    protected void appendProjectionOnFields(SolrQuery solrQuery, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        solrQuery.setParam("fl", new String[]{StringUtils.join(fields, (String)",")});
    }

    protected void appendDefaultOperator(SolrQuery solrQuery, Query.Operator defaultOperator) {
        if (defaultOperator != null && !Query.Operator.NONE.equals((Object)defaultOperator)) {
            solrQuery.set("q.op", new String[]{defaultOperator.asQueryStringRepresentation()});
        }
    }

    protected void appendTimeAllowed(SolrQuery solrQuery, Integer timeAllowed) {
        if (timeAllowed != null) {
            solrQuery.setTimeAllowed(timeAllowed);
        }
    }

    protected void appendDefType(SolrQuery solrQuery, String defType) {
        if (StringUtils.isNotBlank((CharSequence)defType)) {
            solrQuery.set("defType", new String[]{defType});
        }
    }

    protected void appendRequestHandler(SolrQuery solrQuery, String requestHandler) {
        if (StringUtils.isNotBlank((CharSequence)requestHandler)) {
            solrQuery.add("qt", new String[]{requestHandler});
        }
    }

    private boolean containsFunctionCriteria(Set<Criteria.CriteriaEntry> chainedCriterias) {
        for (Criteria.CriteriaEntry entry : chainedCriterias) {
            if (StringUtils.equals((CharSequence)Criteria.OperationKey.WITHIN.getKey(), (CharSequence)entry.getKey())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)Criteria.OperationKey.NEAR.getKey(), (CharSequence)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrQuery constructSolrQuery(SolrDataQuery query) {
        return this.doConstructSolrQuery(query);
    }

    public abstract SolrQuery doConstructSolrQuery(QUERYTPYE var1);

    class WildcardProcessor
    extends BaseCriteriaEntryProcessor {
        WildcardProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.CONTAINS.getKey().equals(criteriaEntry.getKey()) || Criteria.OperationKey.STARTS_WITH.getKey().equals(criteriaEntry.getKey()) || Criteria.OperationKey.ENDS_WITH.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        protected Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            Object filteredValue = this.filterCriteriaValue(criteriaEntry.getValue());
            if (Criteria.OperationKey.CONTAINS.getKey().equals(criteriaEntry.getKey())) {
                return "*" + filteredValue + "*";
            }
            if (Criteria.OperationKey.STARTS_WITH.getKey().equals(criteriaEntry.getKey())) {
                return filteredValue + "*";
            }
            if (Criteria.OperationKey.ENDS_WITH.getKey().equals(criteriaEntry.getKey())) {
                return "*" + filteredValue;
            }
            return filteredValue;
        }
    }

    class SloppyProcessor
    extends BaseCriteriaEntryProcessor {
        SloppyProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.SLOPPY.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        protected Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            Object[] args = (Object[])criteriaEntry.getValue();
            Integer distance = (Integer)args[1];
            return this.filterCriteriaValue(args[0]) + "~" + distance;
        }
    }

    class FuzzyProcessor
    extends BaseCriteriaEntryProcessor {
        FuzzyProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.FUZZY.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        protected Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            Object[] args = (Object[])criteriaEntry.getValue();
            Float distance = (Float)args[1];
            return this.filterCriteriaValue(args[0]) + "~" + (distance.isNaN() ? "" : distance);
        }
    }

    class WithinProcessor
    extends NearProcessor {
        WithinProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.WITHIN.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        public Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            Object[] args = (Object[])criteriaEntry.getValue();
            return this.createSpatialFunctionFragment(field.getName(), (GeoLocation)args[0], (Distance)args[1], "geofilt");
        }
    }

    class NearProcessor
    extends BetweenProcessor {
        NearProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.NEAR.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        public Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            String nearFragment;
            Object[] args = (Object[])criteriaEntry.getValue();
            if (args[0] instanceof BoundingBox) {
                BoundingBox box = (BoundingBox)args[0];
                nearFragment = field.getName() + ":[";
                nearFragment = nearFragment + this.createRangeFragment(box.getGeoLocationStart(), box.getGeoLocationEnd());
                nearFragment = nearFragment + "]";
            } else {
                nearFragment = this.createSpatialFunctionFragment(field.getName(), (GeoLocation)args[0], (Distance)args[1], "bbox");
            }
            return nearFragment;
        }

        protected String createSpatialFunctionFragment(String fieldName, GeoLocation location, Distance distance, String function) {
            String spatialFragment = "{!" + function + QueryParserBase.CRITERIA_VALUE_SEPERATOR + "pt" + "=";
            spatialFragment = spatialFragment + this.filterCriteriaValue(location);
            spatialFragment = spatialFragment + " sfield=" + fieldName;
            spatialFragment = spatialFragment + " d=" + this.filterCriteriaValue(distance);
            spatialFragment = spatialFragment + "}";
            return spatialFragment;
        }
    }

    class BetweenProcessor
    extends BaseCriteriaEntryProcessor {
        private static final String RANGE_OPERATOR = " TO ";

        BetweenProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.BETWEEN.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        public Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            Object[] args = (Object[])criteriaEntry.getValue();
            String rangeFragment = (Boolean)args[2] != false ? "[" : "{";
            rangeFragment = rangeFragment + this.createRangeFragment(args[0], args[1]);
            rangeFragment = rangeFragment + ((Boolean)args[3] != false ? "]" : "}");
            return rangeFragment;
        }

        protected String createRangeFragment(Object rangeStart, Object rangeEnd) {
            String rangeFragment = "";
            rangeFragment = rangeFragment + (rangeStart != null ? this.filterCriteriaValue(rangeStart) : "*");
            rangeFragment = rangeFragment + RANGE_OPERATOR;
            rangeFragment = rangeFragment + (rangeEnd != null ? this.filterCriteriaValue(rangeEnd) : "*");
            return rangeFragment;
        }
    }

    class ExpressionProcessor
    extends BaseCriteriaEntryProcessor {
        ExpressionProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return Criteria.OperationKey.EXPRESSION.getKey().equals(criteriaEntry.getKey());
        }

        @Override
        public Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            return criteriaEntry.getValue().toString();
        }
    }

    class DefaultProcessor
    extends BaseCriteriaEntryProcessor {
        DefaultProcessor() {
        }

        @Override
        public boolean canProcess(Criteria.CriteriaEntry criteriaEntry) {
            return true;
        }

        @Override
        public Object doProcess(Criteria.CriteriaEntry criteriaEntry, Field field) {
            return this.filterCriteriaValue(criteriaEntry.getValue());
        }
    }

    abstract class BaseCriteriaEntryProcessor
    implements CriteriaEntryProcessor {
        protected static final String DOUBLEQUOTE = "\"";
        protected final String[] RESERVED_CHARS = new String[]{"\"", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "~", "*", "?", ":", "\\"};
        protected String[] RESERVED_CHARS_REPLACEMENT = new String[]{"\\\"", "\\+", "\\-", "\\&\\&", "\\|\\|", "\\!", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\^", "\\~", "\\*", "\\?", "\\:", "\\\\"};

        BaseCriteriaEntryProcessor() {
        }

        @Override
        public Object process(Criteria.CriteriaEntry criteriaEntry, Field field) {
            if (criteriaEntry == null || criteriaEntry.getValue() == null) {
                return null;
            }
            return this.doProcess(criteriaEntry, field);
        }

        protected Object filterCriteriaValue(Object criteriaValue) {
            if (!(criteriaValue instanceof String)) {
                if (QueryParserBase.this.conversionService.canConvert(criteriaValue.getClass(), String.class)) {
                    return QueryParserBase.this.conversionService.convert(criteriaValue, String.class);
                }
                return criteriaValue;
            }
            String value = this.escapeCriteriaValue((String)criteriaValue);
            return this.processWhiteSpaces(value);
        }

        private String escapeCriteriaValue(String criteriaValue) {
            return StringUtils.replaceEach((String)criteriaValue, (String[])this.RESERVED_CHARS, (String[])this.RESERVED_CHARS_REPLACEMENT);
        }

        private String processWhiteSpaces(String criteriaValue) {
            if (StringUtils.contains((CharSequence)criteriaValue, (CharSequence)QueryParserBase.CRITERIA_VALUE_SEPERATOR)) {
                return DOUBLEQUOTE + criteriaValue + DOUBLEQUOTE;
            }
            return criteriaValue;
        }

        protected abstract Object doProcess(Criteria.CriteriaEntry var1, Field var2);
    }

    class CriteriaQueryStringValueProvider
    implements Iterator<String> {
        private final Criteria criteria;
        private Iterator<Criteria.CriteriaEntry> delegate;

        CriteriaQueryStringValueProvider(Criteria criteria) {
            Assert.notNull((Object)criteria, (String)"Unable to provide values for 'null' criteria");
            this.criteria = criteria;
            this.delegate = criteria.getCriteriaEntries().iterator();
        }

        private <T> T getCriteriaEntryValue(Criteria.CriteriaEntry entry) {
            CriteriaEntryProcessor processor = this.findMatchingProcessor(entry);
            return (T)processor.process(entry, this.criteria.getField());
        }

        private CriteriaEntryProcessor findMatchingProcessor(Criteria.CriteriaEntry criteriaEntry) {
            for (CriteriaEntryProcessor processor : QueryParserBase.this.critieraEntryProcessors) {
                if (!processor.canProcess(criteriaEntry)) continue;
                return processor;
            }
            return QueryParserBase.this.defaultProcessor;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public String next() {
            Object o = this.getCriteriaEntryValue(this.delegate.next());
            String s = o != null ? o.toString() : null;
            return s;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static interface CriteriaEntryProcessor {
        public boolean canProcess(Criteria.CriteriaEntry var1);

        public Object process(Criteria.CriteriaEntry var1, Field var2);
    }
}

