/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryParameter;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultQueryParser
extends QueryParserBase<SolrDataQuery> {
    @Override
    public final SolrQuery doConstructSolrQuery(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Cannot construct solrQuery from null value.");
        Assert.notNull((Object)query.getCriteria(), (String)"Query has to have a criteria.");
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setParam("q", new String[]{this.getQueryString(query)});
        if (query instanceof Query) {
            this.processQueryOptions(solrQuery, (Query)query);
        }
        if (query instanceof FacetQuery) {
            this.processFacetOptions(solrQuery, (FacetQuery)query);
        }
        if (query instanceof HighlightQuery) {
            this.processHighlightOptions(solrQuery, (HighlightQuery)query);
        }
        return solrQuery;
    }

    private void processQueryOptions(SolrQuery solrQuery, Query query) {
        this.appendPagination(solrQuery, query.getPageRequest());
        this.appendProjectionOnFields(solrQuery, query.getProjectionOnFields());
        this.appendGroupByFields(solrQuery, query.getGroupByFields());
        this.appendFilterQuery(solrQuery, query.getFilterQueries());
        this.appendSort(solrQuery, query.getSort());
        this.appendDefaultOperator(solrQuery, query.getDefaultOperator());
        this.appendTimeAllowed(solrQuery, query.getTimeAllowed());
        this.appendDefType(solrQuery, query.getDefType());
        this.appendRequestHandler(solrQuery, query.getRequestHandler());
    }

    private void processFacetOptions(SolrQuery solrQuery, FacetQuery query) {
        if (this.enableFaceting(solrQuery, query)) {
            this.appendFacetingOnFields(solrQuery, query);
            this.appendFacetingQueries(solrQuery, query);
        }
    }

    protected void processHighlightOptions(SolrQuery solrQuery, HighlightQuery query) {
        if (query.hasHighlightOptions()) {
            HighlightOptions highlightOptions = query.getHighlightOptions();
            solrQuery.setHighlight(true);
            if (!highlightOptions.hasFields()) {
                solrQuery.addHighlightField(HighlightOptions.ALL_FIELDS.getName());
            } else {
                for (Field field : highlightOptions.getFields()) {
                    solrQuery.addHighlightField(field.getName());
                }
                for (HighlightOptions.FieldWithHighlightParameters fieldWithHighlightParameters : highlightOptions.getFieldsWithHighlightParameters()) {
                    this.addPerFieldHighlightParameters(solrQuery, fieldWithHighlightParameters);
                }
            }
            for (HighlightOptions.HighlightParameter option : highlightOptions.getHighlightParameters()) {
                this.addOptionToSolrQuery(solrQuery, option);
            }
            if (highlightOptions.hasQuery()) {
                solrQuery.add("hl.q", new String[]{this.getQueryString(highlightOptions.getQuery())});
            }
        }
    }

    private void addOptionToSolrQuery(SolrQuery solrQuery, QueryParameter option) {
        if (option != null && StringUtils.isNotBlank((CharSequence)option.getName())) {
            solrQuery.add(option.getName(), new String[]{(String)this.conversionService.convert(option.getValue(), String.class)});
        }
    }

    private void addFieldSpecificParameterToSolrQuery(SolrQuery solrQuery, Field field, QueryParameter option) {
        if (option != null && field != null && StringUtils.isNotBlank((CharSequence)option.getName())) {
            if (option.getValue() == null) {
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName()), new String[]{null});
            } else {
                String value = option.getValue().toString();
                if (this.conversionService.canConvert(option.getValue().getClass(), String.class)) {
                    value = (String)this.conversionService.convert(option.getValue(), String.class);
                }
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName()), new String[]{value});
            }
        }
    }

    private void addPerFieldHighlightParameters(SolrQuery solrQuery, HighlightOptions.FieldWithHighlightParameters field) {
        for (HighlightOptions.HighlightParameter option : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, option);
        }
    }

    protected String createPerFieldOverrideParameterName(Field field, String parameterName) {
        return "f." + field.getName() + "." + parameterName;
    }

    private boolean enableFaceting(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions == null || !facetOptions.hasFields() && !facetOptions.hasFacetQueries()) {
            return false;
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(facetOptions.getFacetMinCount());
        solrQuery.setFacetLimit(facetOptions.getPageable().getPageSize());
        if (facetOptions.getPageable().getPageNumber() > 0) {
            solrQuery.set("facet.offset", facetOptions.getPageable().getOffset());
        }
        if (FacetOptions.FacetSort.INDEX.equals((Object)facetOptions.getFacetSort())) {
            solrQuery.setFacetSort("index");
        }
        return true;
    }

    private void appendFacetingOnFields(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions.getPageable().getPageNumber() > 0) {
            solrQuery.set("facet.offset", facetOptions.getPageable().getOffset());
        }
        solrQuery.addFacetField(this.convertFieldListToStringArray(facetOptions.getFacetOnFields()));
        if (facetOptions.hasFacetPrefix()) {
            solrQuery.setFacetPrefix(facetOptions.getFacetPrefix());
        }
        for (FacetOptions.FieldWithFacetParameters parametrizedField : facetOptions.getFieldsWithParameters()) {
            this.addPerFieldFacetParameters(solrQuery, parametrizedField);
            if (parametrizedField.getSort() == null || !FacetOptions.FacetSort.INDEX.equals((Object)parametrizedField.getSort())) continue;
            this.addFieldSpecificParameterToSolrQuery(solrQuery, parametrizedField, new FacetOptions.FacetParameter("facet.sort", "index"));
        }
    }

    private void addPerFieldFacetParameters(SolrQuery solrQuery, FacetOptions.FieldWithFacetParameters field) {
        for (FacetOptions.FacetParameter parameter : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, parameter);
        }
    }

    private void appendFacetingQueries(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        for (SolrDataQuery fq : facetOptions.getFacetQueries()) {
            String facetQueryString = this.getQueryString(fq);
            if (!StringUtils.isNotBlank((CharSequence)facetQueryString)) continue;
            solrQuery.addFacetQuery(facetQueryString);
        }
    }

    protected void appendGroupByFields(SolrQuery solrQuery, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (fields.size() > 1) {
            throw new InvalidDataAccessApiUsageException("Cannot group on more than one field with current SolrJ API. Group on single field insead");
        }
        solrQuery.set("group", true);
        solrQuery.setParam("group.main", true);
        for (Field field : fields) {
            solrQuery.add("group.field", new String[]{field.getName()});
        }
    }

    protected void appendFilterQuery(SolrQuery solrQuery, List<FilterQuery> filterQueries) {
        if (CollectionUtils.isEmpty(filterQueries)) {
            return;
        }
        List<String> filterQueryStrings = this.getFilterQueryStrings(filterQueries);
        if (!filterQueryStrings.isEmpty()) {
            solrQuery.setFilterQueries(this.convertStringListToArray(filterQueryStrings));
        }
    }

    protected void appendSort(SolrQuery solrQuery, Sort sort) {
        if (sort == null) {
            return;
        }
        for (Sort.Order order : sort) {
            if (VersionUtil.isSolr420Available()) {
                solrQuery.addSort(order.getProperty(), order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
                continue;
            }
            solrQuery.addSortField(order.getProperty(), order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
    }

    private String[] convertFieldListToStringArray(List<Field> fields) {
        String[] strResult = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            strResult[i] = fields.get(i).getName();
        }
        return strResult;
    }

    private String[] convertStringListToArray(List<String> listOfString) {
        String[] strResult = new String[listOfString.size()];
        listOfString.toArray(strResult);
        return strResult;
    }

    private List<String> getFilterQueryStrings(List<FilterQuery> filterQueries) {
        ArrayList<String> filterQueryStrings = new ArrayList<String>(filterQueries.size());
        for (FilterQuery filterQuery : filterQueries) {
            String filterQueryString = this.getQueryString(filterQuery);
            if (!StringUtils.isNotBlank((CharSequence)filterQueryString)) continue;
            filterQueryStrings.add(filterQueryString);
        }
        return filterQueryStrings;
    }
}

