/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractSegment
implements Segment {
    private final Segment[] children;

    protected AbstractSegment(Segment ... children) {
        this.children = children;
    }

    @Override
    public void visit(Visitor visitor) {
        Assert.notNull((Object)visitor, (String)"Visitor must not be null");
        visitor.enter(this);
        for (Segment child : this.children) {
            child.visit(visitor);
        }
        visitor.leave(this);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj instanceof Segment && this.toString().equals(obj.toString());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + StringUtils.arrayToDelimitedString((Object[])this.children, (String)", ") + ")";
    }
}

