/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.util.Assert;

class DefaultRootAggregateChange<T>
implements RootAggregateChange<T> {
    private final AggregateChange.Kind kind;
    private final Class<T> entityType;
    private final List<DbAction<?>> actions = new ArrayList();
    private @Nullable DbAction.WithRoot<T> rootAction;
    private final @Nullable Number previousVersion;

    DefaultRootAggregateChange(AggregateChange.Kind kind, Class<T> entityType, @Nullable Number previousVersion) {
        this.kind = kind;
        this.entityType = entityType;
        this.previousVersion = previousVersion;
    }

    @Override
    public void addAction(DbAction<?> action) {
        Assert.notNull(action, (String)"Action must not be null");
        this.actions.add(action);
    }

    @Override
    public AggregateChange.Kind getKind() {
        return this.kind;
    }

    @Override
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Override
    public void setRoot(T aggregateRoot) {
        Assert.isInstanceOf(this.entityType, aggregateRoot, (String)String.format("AggregateRoot must be of type %s", this.entityType.getName()));
        Assert.state((this.rootAction != null ? 1 : 0) != 0, (String)"rootAction must not be null");
        this.rootAction.setEntity(aggregateRoot);
    }

    @Override
    public void setRootAction(DbAction.WithRoot<T> action) {
        Assert.isNull(this.rootAction, (String)"The rootAction must be set exactly once");
        this.rootAction = action;
    }

    @Override
    public @Nullable Number getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public T getRoot() {
        Assert.state((this.rootAction != null ? 1 : 0) != 0, (String)"rootAction must not be null");
        return this.rootAction.entity();
    }

    @Override
    public void forEachAction(Consumer<? super DbAction<?>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null");
        Assert.notNull(this.rootAction, (String)"DbAction.WithRoot must not be null");
        consumer.accept(this.rootAction);
        this.actions.forEach(consumer);
    }
}

